/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDriveVirtualEventLogger
implements PostCommitFilteringEventListener {
    private static final Log log = LogFactory.getLog(NuxeoDriveVirtualEventLogger.class);

    public boolean acceptEvent(Event event) {
        return "virtualEventCreated".equals(event.getName());
    }

    public void handleEvent(EventBundle events) {
        AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
        if (logger != null) {
            for (Event event : events) {
                EventContext ctx = event.getContext();
                Object[] args = ctx.getArguments();
                if (ArrayUtils.isEmpty((Object[])args)) {
                    return;
                }
                Object arg = args[0];
                if (!(arg instanceof LogEntry)) {
                    return;
                }
                LogEntry entry = (LogEntry)arg;
                logger.addLogEntries(Collections.singletonList(entry));
            }
        } else {
            log.error((Object)"Can not reach AuditLogger");
        }
    }
}

