/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractFileSystemItemFactory
implements FileSystemItemFactory {
    private static final Log log = LogFactory.getLog(AbstractFileSystemItemFactory.class);
    protected String name;

    @Override
    public abstract void handleParameters(Map<String, String> var1);

    @Override
    public abstract boolean isFileSystemItem(DocumentModel var1, boolean var2, boolean var3);

    protected abstract FileSystemItem adaptDocument(DocumentModel var1, boolean var2, FolderItem var3, boolean var4);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc) {
        return this.isFileSystemItem(doc, false);
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.isFileSystemItem(doc, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc) {
        return this.getFileSystemItem(doc, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem) {
        return this.getFileSystemItem(doc, parentItem, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public boolean canHandleFileSystemItemId(String id) {
        try {
            this.parseFileSystemId(id);
        }
        catch (IllegalArgumentException e) {
            log.trace((Object)e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(String id, Principal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        try (CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);){
            DocumentModel doc = this.getDocumentById(docId, session);
            boolean bl = this.isFileSystemItem(doc);
            return bl;
        }
        catch (DocumentNotFoundException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)String.format("No doc related to id %s, returning false.", docId));
            return false;
        }
        catch (DocumentSecurityException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)String.format("User %s cannot access doc %s, returning false.", principal.getName(), docId));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileSystemItem getFileSystemItemById(String id, Principal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        try (CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);){
            DocumentModel doc = this.getDocumentById(docId, session);
            FileSystemItem fileSystemItem = this.getFileSystemItem(doc);
            return fileSystemItem;
        }
        catch (DocumentNotFoundException e) {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)String.format("No doc related to id %s, returning null.", docId));
            return null;
        }
        catch (DocumentSecurityException e) {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)String.format("User %s cannot access doc %s, returning null.", principal.getName(), docId));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileSystemItem getFileSystemItemById(String id, String parentId, Principal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        try (CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);){
            FileSystemItem parentItem = ((FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class)).getFileSystemItemFactoryForId(parentId).getFileSystemItemById(parentId, principal);
            if (!(parentItem instanceof FolderItem)) {
                throw new NuxeoException(String.format("FileSystemItem with id %s should be a FolderItem", parentId));
            }
            DocumentModel doc = this.getDocumentById(docId, session);
            FileSystemItem fileSystemItem = this.getFileSystemItem(doc, (FolderItem)parentItem);
            return fileSystemItem;
        }
        catch (DocumentNotFoundException e) {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)String.format("No doc related to id %s, returning null.", docId));
            return null;
        }
        catch (DocumentSecurityException e) {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)String.format("User %s cannot access doc %s, returning null.", principal.getName(), docId));
            return null;
        }
    }

    @Override
    @Deprecated
    public DocumentModel getDocumentByFileSystemId(String id, Principal principal) {
        String[] idFragments = this.parseFileSystemId(id);
        String repositoryName = idFragments[1];
        String docId = idFragments[2];
        CoreSession session = ((FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class)).getSession(repositoryName, principal);
        return this.getDocumentById(docId, session);
    }

    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem) {
        return this.adaptDocument(doc, forceParentItem, parentItem, false);
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        if (!this.isFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Document %s cannot be adapted as a FileSystemItem => returning null.", doc.getId()));
            }
            return null;
        }
        return this.adaptDocument(doc, forceParentItem, parentItem, relaxSyncRootConstraint);
    }

    protected String[] parseFileSystemId(String id) {
        String[] idFragments = id.split("#");
        if (idFragments.length != 3) {
            throw new IllegalArgumentException(String.format("FileSystemItem id %s cannot be handled by factory named %s. Should match the 'fileSystemItemFactoryName#repositoryName#docId' pattern.", id, this.name));
        }
        String factoryName = idFragments[0];
        if (!this.name.equals(factoryName)) {
            throw new IllegalArgumentException(String.format("Factoy name [%s] parsed from id %s does not match the actual factory name [%s].", factoryName, id, this.name));
        }
        return idFragments;
    }

    protected DocumentModel getDocumentById(String docId, CoreSession session) {
        return session.getDocument((DocumentRef)new IdRef(docId));
    }
}

