/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.security.Principal;
import java.util.Calendar;
import java.util.List;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.AbstractFileSystemItem;
import org.nuxeo.drive.service.impl.NuxeoDriveManagerImpl;
import org.nuxeo.ecm.core.api.Blob;

public abstract class AbstractVirtualFolderItem
extends AbstractFileSystemItem
implements FolderItem {
    private static final long serialVersionUID = 1L;
    protected boolean canCreateChild;

    public AbstractVirtualFolderItem(String factoryName, Principal principal, String parentId, String parentPath, String folderName) {
        super(factoryName, principal, false);
        this.parentId = parentId;
        this.name = folderName;
        this.folder = true;
        this.creator = "system";
        this.lastContributor = "system";
        this.creationDate = Calendar.getInstance(NuxeoDriveManagerImpl.UTC);
        this.creationDate.set(1970, 0, 1, 0, 0, 0);
        this.lastModificationDate = this.creationDate;
        this.canRename = false;
        this.canDelete = false;
        this.canCreateChild = false;
        this.path = "/" + this.getId();
        if (parentPath != null) {
            this.path = parentPath + this.path;
        }
    }

    protected AbstractVirtualFolderItem() {
    }

    @Override
    public abstract List<FileSystemItem> getChildren();

    @Override
    public void rename(String name) {
        throw new UnsupportedOperationException("Cannot rename a virtual folder item.");
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a virtual folder item.");
    }

    @Override
    public boolean canMove(FolderItem dest) {
        return false;
    }

    @Override
    public FileSystemItem move(FolderItem dest) {
        throw new UnsupportedOperationException("Cannot move a virtual folder item.");
    }

    @Override
    public boolean getCanCreateChild() {
        return this.canCreateChild;
    }

    @Override
    public FolderItem createFolder(String name) {
        throw new UnsupportedOperationException("Cannot create a folder in a virtual folder item.");
    }

    @Override
    public FileItem createFile(Blob blob) {
        throw new UnsupportedOperationException("Cannot create a file in a virtual folder item.");
    }

    protected void setCanCreateChild(boolean canCreateChild) {
        this.canCreateChild = canCreateChild;
    }
}

