/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.ChangeFinderDescriptor;
import org.nuxeo.drive.service.impl.ChangeFinderRegistry;
import org.nuxeo.drive.service.impl.FileSystemChangeSummaryImpl;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoDriveManagerImpl
extends DefaultComponent
implements NuxeoDriveManager {
    private static final Log log = LogFactory.getLog(NuxeoDriveManagerImpl.class);
    public static final String CHANGE_FINDER_EP = "changeFinder";
    public static final String NUXEO_DRIVE_FACET = "DriveSynchronized";
    public static final String DRIVE_SUBSCRIPTIONS_PROPERTY = "drv:subscriptions";
    public static final String DOCUMENT_CHANGE_LIMIT_PROPERTY = "org.nuxeo.drive.document.change.limit";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected static final long COLLECTION_CONTENT_PAGE_SIZE = 1000L;
    protected Cache<String, Map<String, SynchronizationRoots>> syncRootCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    protected Cache<String, Map<String, Set<String>>> collectionSyncRootMemberCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    protected static ChangeFinderRegistry changeFinderRegistry;
    protected FileSystemChangeFinder changeFinder;

    protected void clearCache() {
        log.debug((Object)"Invalidating synchronization root cache and collection sync root member cache for all users");
        this.syncRootCache.invalidateAll();
        this.collectionSyncRootMemberCache.invalidateAll();
    }

    @Override
    public void invalidateSynchronizationRootsCache(String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating synchronization root cache for user: " + userName));
        }
        this.syncRootCache.invalidate((Object)userName);
    }

    @Override
    public void invalidateCollectionSyncRootMemberCache(String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating collection sync root member cache for user: " + userName));
        }
        this.collectionSyncRootMemberCache.invalidate((Object)userName);
    }

    @Override
    public void invalidateCollectionSyncRootMemberCache() {
        log.debug((Object)"Invalidating collection sync root member cache for all users");
        this.collectionSyncRootMemberCache.invalidateAll();
    }

    @Override
    public void registerSynchronizationRoot(Principal principal, final DocumentModel newRootContainer, CoreSession session) {
        final String userName = principal.getName();
        Map<String, SynchronizationRoots> syncRoots = this.getSynchronizationRoots(principal);
        SynchronizationRoots synchronizationRoots = syncRoots.get(session.getRepositoryName());
        if (!"Locally Edited".equals(newRootContainer.getName())) {
            for (String string : synchronizationRoots.getPaths()) {
                String parentPathAsString;
                String syncRootPrefixedPath = string + "/";
                if (!newRootContainer.getPathAsString().startsWith(syncRootPrefixedPath)) continue;
                boolean rightInheritanceBlockedInTheHierarchy = false;
                Path parentPath = newRootContainer.getPath().removeLastSegments(1);
                while (!"/".equals(parentPath.toString()) && (parentPathAsString = parentPath.toString() + "/").startsWith(syncRootPrefixedPath)) {
                    PathRef parentRef = new PathRef(parentPathAsString);
                    if (!session.hasPermission(principal, (DocumentRef)parentRef, "Read")) {
                        rightInheritanceBlockedInTheHierarchy = true;
                        break;
                    }
                    parentPath = parentPath.removeLastSegments(1);
                }
                if (rightInheritanceBlockedInTheHierarchy) continue;
                return;
            }
        }
        this.checkCanUpdateSynchronizationRoot(newRootContainer, session);
        String newRootPrefixedPath = newRootContainer.getPathAsString() + "/";
        for (String existingRootPath : synchronizationRoots.getPaths()) {
            PathRef ref;
            if (existingRootPath.endsWith("Locally Edited") || !existingRootPath.startsWith(newRootPrefixedPath) || !session.exists((DocumentRef)(ref = new PathRef(existingRootPath)))) continue;
            DocumentModel subFolder = session.getDocument((DocumentRef)ref);
            this.unregisterSynchronizationRoot(principal, subFolder, session);
        }
        UnrestrictedSessionRunner unrestrictedSessionRunner = new UnrestrictedSessionRunner(session){

            public void run() {
                if (!newRootContainer.hasFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET)) {
                    newRootContainer.addFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET);
                }
                NuxeoDriveManagerImpl.this.fireEvent(newRootContainer, this.session, "aboutToRegisterRoot", userName);
                List subscriptions = (List)((Object)newRootContainer.getPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY));
                boolean updated = false;
                for (Map subscription : subscriptions) {
                    if (!userName.equals(subscription.get("username"))) continue;
                    subscription.put("enabled", Boolean.TRUE);
                    subscription.put("lastChangeDate", Calendar.getInstance(UTC));
                    updated = true;
                    break;
                }
                if (!updated) {
                    HashMap<String, Object> subscription = new HashMap<String, Object>();
                    subscription.put("username", userName);
                    subscription.put("enabled", Boolean.TRUE);
                    subscription.put("lastChangeDate", Calendar.getInstance(UTC));
                    subscriptions.add(subscription);
                }
                newRootContainer.setPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY, (Serializable)((Object)subscriptions));
                newRootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
                newRootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
                DocumentModel savedNewRootContainer = this.session.saveDocument(newRootContainer);
                newRootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(false));
                newRootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(false));
                NuxeoDriveManagerImpl.this.fireEvent(savedNewRootContainer, this.session, "rootRegistered", userName);
                this.session.save();
            }
        };
        unrestrictedSessionRunner.runUnrestricted();
        this.invalidateSynchronizationRootsCache(userName);
        this.invalidateCollectionSyncRootMemberCache(userName);
    }

    @Override
    public void unregisterSynchronizationRoot(Principal principal, final DocumentModel rootContainer, CoreSession session) {
        final String userName = principal.getName();
        this.checkCanUpdateSynchronizationRoot(rootContainer, session);
        UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(session){

            public void run() {
                if (!rootContainer.hasFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET)) {
                    rootContainer.addFacet(NuxeoDriveManagerImpl.NUXEO_DRIVE_FACET);
                }
                NuxeoDriveManagerImpl.this.fireEvent(rootContainer, this.session, "aboutToUnRegisterRoot", userName);
                List subscriptions = (List)((Object)rootContainer.getPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY));
                for (Map subscription : subscriptions) {
                    if (!userName.equals(subscription.get("username"))) continue;
                    subscription.put("enabled", Boolean.FALSE);
                    subscription.put("lastChangeDate", Calendar.getInstance(UTC));
                    break;
                }
                rootContainer.setPropertyValue(NuxeoDriveManagerImpl.DRIVE_SUBSCRIPTIONS_PROPERTY, (Serializable)((Object)subscriptions));
                rootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
                rootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
                this.session.saveDocument(rootContainer);
                rootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(false));
                rootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(false));
                NuxeoDriveManagerImpl.this.fireEvent(rootContainer, this.session, "rootUnregistered", userName);
                this.session.save();
            }
        };
        runner.runUnrestricted();
        this.invalidateSynchronizationRootsCache(userName);
        this.invalidateCollectionSyncRootMemberCache(userName);
    }

    @Override
    public Set<IdRef> getSynchronizationRootReferences(CoreSession session) {
        Map<String, SynchronizationRoots> syncRoots = this.getSynchronizationRoots(session.getPrincipal());
        return syncRoots.get(session.getRepositoryName()).getRefs();
    }

    @Override
    public void handleFolderDeletion(IdRef deleted) {
        this.clearCache();
    }

    protected void fireEvent(DocumentModel sourceDocument, CoreSession session, String eventName, String impactedUserName) {
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), sourceDocument);
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)session.getSessionId()));
        ctx.setProperty("category", NuxeoDriveEvents.EVENT_CATEGORY);
        ctx.setProperty("impactedUserName", (Serializable)((Object)impactedUserName));
        Event event = ctx.newEvent(eventName);
        eventService.fireEvent(event);
    }

    @Override
    public FileSystemChangeSummary getChangeSummary(Principal principal, Map<String, Set<IdRef>> lastSyncRootRefs, long lastSuccessfulSync) {
        Map<String, SynchronizationRoots> roots = this.getSynchronizationRoots(principal);
        return this.getChangeSummary(principal, lastSyncRootRefs, roots, new HashMap<String, Set<String>>(), lastSuccessfulSync, false);
    }

    @Override
    public FileSystemChangeSummary getChangeSummaryIntegerBounds(Principal principal, Map<String, Set<IdRef>> lastSyncRootRefs, long lowerBound) {
        Map<String, SynchronizationRoots> roots = this.getSynchronizationRoots(principal);
        Map<String, Set<String>> collectionSyncRootMemberIds = this.getCollectionSyncRootMemberIds(principal);
        return this.getChangeSummary(principal, lastSyncRootRefs, roots, collectionSyncRootMemberIds, lowerBound, true);
    }

    protected FileSystemChangeSummary getChangeSummary(Principal principal, Map<String, Set<IdRef>> lastActiveRootRefs, Map<String, SynchronizationRoots> roots, Map<String, Set<String>> collectionSyncRootMemberIds, long lowerBound, boolean integerBounds) {
        long syncDate;
        long upperBound;
        ArrayList<FileSystemItemChange> allChanges = new ArrayList<FileSystemItemChange>();
        if (integerBounds) {
            upperBound = this.changeFinder.getUpperBound();
            syncDate = System.currentTimeMillis();
            syncDate -= syncDate % 1000L;
        } else {
            syncDate = upperBound = this.changeFinder.getCurrentDate();
        }
        Boolean hasTooManyChanges = Boolean.FALSE;
        int limit = Integer.parseInt(Framework.getProperty((String)DOCUMENT_CHANGE_LIMIT_PROPERTY, (String)"1000"));
        TreeSet<String> allRepositories = new TreeSet<String>();
        allRepositories.addAll(roots.keySet());
        allRepositories.addAll(lastActiveRootRefs.keySet());
        allRepositories.addAll(collectionSyncRootMemberIds.keySet());
        if (!allRepositories.isEmpty() && lowerBound >= 0L && upperBound > lowerBound) {
            for (String repositoryName : allRepositories) {
                try {
                    CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);
                    Throwable throwable = null;
                    try {
                        Set<String> repoCollectionSyncRootMemberIds;
                        SynchronizationRoots activeRoots;
                        Set<Object> lastRefs = lastActiveRootRefs.get(repositoryName);
                        if (lastRefs == null) {
                            lastRefs = Collections.emptySet();
                        }
                        if ((activeRoots = roots.get(repositoryName)) == null) {
                            activeRoots = SynchronizationRoots.getEmptyRoots(repositoryName);
                        }
                        if ((repoCollectionSyncRootMemberIds = collectionSyncRootMemberIds.get(repositoryName)) == null) {
                            repoCollectionSyncRootMemberIds = Collections.emptySet();
                        }
                        List<FileSystemItemChange> changes = integerBounds ? this.changeFinder.getFileSystemChangesIntegerBounds(session, lastRefs, activeRoots, repoCollectionSyncRootMemberIds, lowerBound, upperBound, limit) : this.changeFinder.getFileSystemChanges(session, lastRefs, activeRoots, lowerBound, upperBound, limit);
                        allChanges.addAll(changes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (session == null) continue;
                        if (throwable != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        session.close();
                    }
                }
                catch (TooManyChangesException e) {
                    hasTooManyChanges = Boolean.TRUE;
                    allChanges.clear();
                    break;
                }
            }
        }
        HashMap<String, Set<IdRef>> activeRootRefs = new HashMap<String, Set<IdRef>>();
        for (Map.Entry<String, SynchronizationRoots> rootsEntry : roots.entrySet()) {
            activeRootRefs.put(rootsEntry.getKey(), rootsEntry.getValue().getRefs());
        }
        return new FileSystemChangeSummaryImpl(allChanges, activeRootRefs, syncDate, upperBound, hasTooManyChanges);
    }

    @Override
    public Map<String, SynchronizationRoots> getSynchronizationRoots(Principal principal) {
        String userName = principal.getName();
        Map<String, SynchronizationRoots> syncRoots = (Map<String, SynchronizationRoots>)this.syncRootCache.getIfPresent((Object)userName);
        if (syncRoots == null) {
            syncRoots = this.computeSynchronizationRoots(this.computeSyncRootsQuery(userName), principal);
            this.syncRootCache.put((Object)userName, syncRoots);
        }
        return syncRoots;
    }

    @Override
    public Map<String, Set<String>> getCollectionSyncRootMemberIds(Principal principal) {
        String userName = principal.getName();
        Map<String, Set<String>> collSyncRootMemberIds = (Map<String, Set<String>>)this.collectionSyncRootMemberCache.getIfPresent((Object)userName);
        if (collSyncRootMemberIds == null) {
            collSyncRootMemberIds = this.computeCollectionSyncRootMemberIds(principal);
            this.collectionSyncRootMemberCache.put((Object)userName, collSyncRootMemberIds);
        }
        return collSyncRootMemberIds;
    }

    @Override
    public boolean isSynchronizationRoot(Principal principal, DocumentModel doc) {
        String repoName = doc.getRepositoryName();
        SynchronizationRoots syncRoots = this.getSynchronizationRoots(principal).get(repoName);
        return syncRoots.getRefs().contains(doc.getRef());
    }

    protected Map<String, SynchronizationRoots> computeSynchronizationRoots(String query, Principal principal) {
        HashMap<String, SynchronizationRoots> syncRoots = new HashMap<String, SynchronizationRoots>();
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);
            Throwable throwable = null;
            try {
                syncRoots.putAll(this.queryAndFetchSynchronizationRoots(session, query));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
        return syncRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SynchronizationRoots> queryAndFetchSynchronizationRoots(CoreSession session, String query) {
        HashMap<String, SynchronizationRoots> syncRoots = new HashMap<String, SynchronizationRoots>();
        LinkedHashSet<IdRef> references = new LinkedHashSet<IdRef>();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        try (IterableQueryResult results = session.queryAndFetch(query, "NXQL", new Object[0]);){
            for (Map result : results) {
                IdRef docRef = new IdRef(((Serializable)result.get("ecm:uuid")).toString());
                try {
                    DocumentModel doc = session.getDocument((DocumentRef)docRef);
                    references.add(docRef);
                    paths.add(doc.getPathAsString());
                }
                catch (DocumentNotFoundException e) {
                    log.warn((Object)String.format("Document %s not found, not adding it to the list of synchronization roots for user %s.", docRef, session.getPrincipal().getName()));
                }
                catch (DocumentSecurityException e) {
                    log.warn((Object)String.format("User %s cannot access document %s, not adding it to the list of synchronization roots.", session.getPrincipal().getName(), docRef));
                }
            }
        }
        SynchronizationRoots repoSyncRoots = new SynchronizationRoots(session.getRepositoryName(), paths, references);
        syncRoots.put(session.getRepositoryName(), repoSyncRoots);
        return syncRoots;
    }

    protected Map<String, Set<String>> computeCollectionSyncRootMemberIds(Principal principal) {
        HashMap<String, Set<String>> collectionSyncRootMemberIds = new HashMap<String, Set<String>>();
        PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            HashSet<String> collectionMemberIds = new HashSet<String>();
            CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);
            Throwable throwable = null;
            try {
                HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                props.put("coreSession", (Serializable)session);
                PageProvider collectionPageProvider = pageProviderService.getPageProvider("all_collections", null, null, Long.valueOf(0L), props, new Object[0]);
                List collections = collectionPageProvider.getCurrentPage();
                for (DocumentModel collection : collections) {
                    if (!this.isSynchronizationRoot(principal, collection)) continue;
                    PageProvider collectionMemberPageProvider = pageProviderService.getPageProvider("default_content_collection", null, Long.valueOf(1000L), Long.valueOf(0L), props, new Object[]{collection.getId()});
                    List collectionMembers = collectionMemberPageProvider.getCurrentPage();
                    for (DocumentModel collectionMember : collectionMembers) {
                        collectionMemberIds.add(collectionMember.getId());
                    }
                }
                collectionSyncRootMemberIds.put(repositoryName, collectionMemberIds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
        return collectionSyncRootMemberIds;
    }

    protected void checkCanUpdateSynchronizationRoot(DocumentModel newRootContainer, CoreSession session) {
        if (newRootContainer.isProxy() || newRootContainer.isVersion()) {
            throw new NuxeoException(String.format("Document '%s' (%s) is not a suitable synchronization root as it is either a readonly proxy or an archived version.", newRootContainer.getTitle(), newRootContainer.getRef()));
        }
    }

    @Override
    public FileSystemChangeFinder getChangeFinder() {
        return this.changeFinder;
    }

    @Override
    @Deprecated
    public void setChangeFinder(FileSystemChangeFinder changeFinder) {
        this.changeFinder = changeFinder;
    }

    protected String computeSyncRootsQuery(String username) {
        return String.format("SELECT ecm:uuid FROM Document WHERE %s/*1/username = %s AND %s/*1/enabled = 1 AND ecm:currentLifeCycleState <> 'deleted' ORDER BY dc:title, dc:created DESC", DRIVE_SUBSCRIPTIONS_PROPERTY, NXQLQueryBuilder.prepareStringLiteral((String)username, (boolean)true, (boolean)true), DRIVE_SUBSCRIPTIONS_PROPERTY);
    }

    @Override
    public void addToLocallyEditedCollection(CoreSession session, DocumentModel doc) {
        CollectionManager cm = (CollectionManager)Framework.getService(CollectionManager.class);
        DocumentModel userCollections = cm.getUserDefaultCollections(doc, session);
        PathRef locallyEditedCollectionRef = new PathRef(userCollections.getPath().toString(), "Locally Edited");
        DocumentModel locallyEditedCollection = null;
        if (session.exists((DocumentRef)locallyEditedCollectionRef)) {
            locallyEditedCollection = session.getDocument((DocumentRef)locallyEditedCollectionRef);
            cm.addToCollection(locallyEditedCollection, doc, session);
        } else {
            cm.addToNewCollection("Locally Edited", "Documents locally edited with Nuxeo Drive", doc, session);
            locallyEditedCollection = session.getDocument((DocumentRef)locallyEditedCollectionRef);
        }
        Set<IdRef> syncRootRefs = this.getSynchronizationRootReferences(session);
        if (!syncRootRefs.contains(new IdRef(locallyEditedCollection.getId()))) {
            this.registerSynchronizationRoot(session.getPrincipal(), locallyEditedCollection, session);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CHANGE_FINDER_EP.equals(extensionPoint)) {
            changeFinderRegistry.addContribution((ChangeFinderDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CHANGE_FINDER_EP.equals(extensionPoint)) {
            changeFinderRegistry.removeContribution((ChangeFinderDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        if (changeFinderRegistry == null) {
            changeFinderRegistry = new ChangeFinderRegistry();
        }
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        changeFinderRegistry = null;
    }

    public void applicationStarted(ComponentContext context) {
        this.initChangeFinder();
    }

    protected void initChangeFinder() {
        this.changeFinder = NuxeoDriveManagerImpl.changeFinderRegistry.changeFinder;
    }
}

