/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class DefaultSyncRootFolderItem
extends DocumentBackedFolderItem
implements FolderItem {
    private static final long serialVersionUID = 1L;

    public DefaultSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) throws ClientException {
        this(factoryName, parentItem, doc, false);
    }

    public DefaultSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) throws ClientException {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint);
        this.canDelete = true;
    }

    protected DefaultSyncRootFolderItem() {
    }

    @Override
    public void delete() throws ClientException {
        CoreSession session = this.getSession();
        DocumentModel doc = this.getDocument(session);
        ((NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class)).unregisterSynchronizationRoot(this.principal, doc, session);
    }

    @Override
    public boolean canMove(FolderItem dest) throws ClientException {
        return false;
    }

    @Override
    public FileSystemItem move(FolderItem dest) throws ClientException {
        throw new UnsupportedOperationException("Cannot move a synchronization root folder item.");
    }
}

