/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import org.nuxeo.drive.adapter.impl.FileSystemItemHelper;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.drive.service.impl.FileSystemItemAdapterServiceImpl;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.AttachBlob", category="Services", label="Nuxeo Drive: Attach blob")
public class NuxeoDriveAttachBlob {
    public static final String ID = "NuxeoDrive.AttachBlob";
    @Context
    protected CoreSession session;
    @Param(name="document")
    protected DocumentModel doc;
    @Param(name="applyVersioningPolicy", required=false, values={"false"})
    protected boolean applyVersioningPolicy = false;
    @Param(name="factoryName", required=false, values={"defaultFileSystemItemFactory"})
    protected String factoryName = "defaultFileSystemItemFactory";

    @OperationMethod
    public Blob run(Blob blob) throws ClientException {
        BlobHolder bh;
        if (this.applyVersioningPolicy) {
            FileSystemItemFactory factory = ((FileSystemItemAdapterServiceImpl)Framework.getService(FileSystemItemAdapterService.class)).getFileSystemItemFactory(this.factoryName);
            if (!(factory instanceof VersioningFileSystemItemFactory)) {
                throw new NuxeoException(String.format("Factory %s must implement VersioningFileSystemItemFactory.", this.factoryName));
            }
            VersioningFileSystemItemFactory versioningFactory = (VersioningFileSystemItemFactory)factory;
            FileSystemItemHelper.versionIfNeeded((VersioningFileSystemItemFactory)versioningFactory, (DocumentModel)this.doc, (CoreSession)this.session);
        }
        if ((bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class)) == null) {
            throw new NuxeoException(String.format("Document %s is not a BlobHolder, no blob can be attached to it.", this.doc.getId()));
        }
        bh.setBlob(blob);
        this.session.saveDocument(this.doc);
        return blob;
    }
}

