/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.impl.NuxeoDriveManagerImpl;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

@Operation(id="NuxeoDrive.GenerateConflictedItemName", category="Services", label="Nuxeo Drive: Generate Conflicted Item Name")
public class NuxeoDriveGenerateConflictedItemName {
    public static final String ID = "NuxeoDrive.GenerateConflictedItemName";
    @Context
    protected OperationContext ctx;
    @Param(name="name")
    protected String name;

    @OperationMethod
    public Blob run() throws ClientException, IOException {
        String extension = "";
        if (this.name.contains(".")) {
            String[] parts = this.name.split("\\.(?=[^\\.]+$)");
            this.name = parts[0];
            extension = "." + parts[1];
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
        String userName = principal.getName();
        if (!StringUtils.isBlank((String)principal.getLastName()) && !StringUtils.isBlank((String)principal.getFirstName())) {
            userName = principal.getFirstName() + " " + principal.getLastName();
        }
        Calendar userDate = Calendar.getInstance(NuxeoDriveManagerImpl.UTC);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh-mm");
        dateFormat.setCalendar(userDate);
        String formatedDate = dateFormat.format(userDate.getTime());
        String contextSection = String.format(" (%s - %s)", userName, formatedDate);
        String conflictedName = this.name + contextSection + extension;
        return NuxeoDriveOperationHelper.asJSONBlob(conflictedName);
    }
}

