/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.runtime.api.Framework;

public class UserSyncRootParentFolderItem
extends DocumentBackedFolderItem {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserSyncRootParentFolderItem.class);
    protected boolean isUserWorkspaceSyncRoot = false;

    public UserSyncRootParentFolderItem(String factoryName, DocumentModel doc, FolderItem parentItem, String folderName) throws ClientException {
        super(factoryName, parentItem, doc);
        this.name = folderName;
        this.canRename = false;
        this.canDelete = false;
        this.canCreateChild = this.isUserWorkspaceSyncRoot = this.isUserWorkspaceSyncRoot(doc);
    }

    protected UserSyncRootParentFolderItem() {
    }

    @Override
    public void rename(String name) throws ClientException {
        throw new UnsupportedOperationException("Cannot rename a virtual folder item.");
    }

    @Override
    public void delete() throws ClientException {
        throw new UnsupportedOperationException("Cannot delete a virtual folder item.");
    }

    @Override
    public FileSystemItem move(FolderItem dest) throws ClientException {
        throw new UnsupportedOperationException("Cannot move a virtual folder item.");
    }

    @Override
    public List<FileSystemItem> getChildren() throws ClientException {
        if (this.isUserWorkspaceSyncRoot) {
            return super.getChildren();
        }
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
        Map<String, SynchronizationRoots> syncRootsByRepo = ((NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class)).getSynchronizationRoots(this.principal);
        for (String repositoryName : syncRootsByRepo.keySet()) {
            CoreSession session = this.getSession(repositoryName);
            Set<IdRef> syncRootRefs = syncRootsByRepo.get(repositoryName).getRefs();
            for (IdRef idRef : syncRootRefs) {
                if (!session.hasPermission((DocumentRef)idRef, "Read")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("User %s has no READ access on synchronization root %s, not including it in children.", session.getPrincipal().getName(), idRef));
                    continue;
                }
                DocumentModel doc = session.getDocument((DocumentRef)idRef);
                if (!session.getPrincipal().getName().equals(doc.getPropertyValue("dc:creator"))) continue;
                FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(doc, this);
                if (child == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Synchronization root %s cannot be adapted as a FileSystemItem, maybe because user %s doesn't have the required permission on it (default required permission is ReadWrite). Not including it in children.", idRef, session.getPrincipal().getName()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Including synchronization root %s in children.", idRef));
                }
                children.add(child);
            }
        }
        Collections.sort(children);
        return children;
    }

    private boolean isUserWorkspaceSyncRoot(DocumentModel doc) throws ClientException {
        NuxeoDriveManager nuxeoDriveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        return nuxeoDriveManager.isSynchronizationRoot(this.principal, doc);
    }
}

