/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.AbstractDocumentBackedFileSystemItem;
import org.nuxeo.drive.adapter.impl.FileSystemItemHelper;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;

public class DocumentBackedFileItem
extends AbstractDocumentBackedFileSystemItem
implements FileItem {
    private static final long serialVersionUID = 1L;
    protected String downloadURL;
    protected String digestAlgorithm;
    protected String digest;
    protected boolean canUpdate;
    protected VersioningFileSystemItemFactory factory;

    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, DocumentModel doc, boolean relaxSyncRootConstraint) throws ClientException {
        super(factory.getName(), doc, relaxSyncRootConstraint);
        this.initialize(factory, doc);
    }

    public DocumentBackedFileItem(VersioningFileSystemItemFactory factory, FolderItem parentItem, DocumentModel doc) throws ClientException {
        super(factory.getName(), parentItem, doc);
        this.initialize(factory, doc);
    }

    protected DocumentBackedFileItem() {
    }

    @Override
    public void rename(String name) throws ClientException {
        CoreSession session = this.getSession();
        DocumentModel doc = this.getDocument(session);
        this.versionIfNeeded(doc, session);
        BlobHolder bh = this.getBlobHolder(doc);
        Blob blob = this.getBlob(bh);
        blob.setFilename(name);
        bh.setBlob(blob);
        this.updateDocTitleIfNeeded(doc, name);
        doc = session.saveDocument(doc);
        session.save();
        this.name = name;
        this.updateDownloadURL();
        this.updateLastModificationDate(doc);
    }

    @Override
    public Blob getBlob() throws ClientException {
        DocumentModel doc = this.getDocument(this.getSession());
        return this.getBlob(doc);
    }

    @Override
    public String getDownloadURL() throws ClientException {
        return this.downloadURL;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public boolean getCanUpdate() {
        return this.canUpdate;
    }

    @Override
    public void setBlob(Blob blob) throws ClientException {
        CoreSession session = this.getSession();
        DocumentModel doc = this.getDocument(session);
        this.versionIfNeeded(doc, session);
        String blobFileName = blob.getFilename();
        if (StringUtils.isEmpty((String)blobFileName)) {
            blob.setFilename(this.name);
        } else {
            this.updateDocTitleIfNeeded(doc, blobFileName);
            this.name = blobFileName;
            this.updateDownloadURL();
        }
        BlobHolder bh = this.getBlobHolder(doc);
        bh.setBlob(blob);
        doc = session.saveDocument(doc);
        session.save();
        this.updateLastModificationDate(doc);
        this.updateDigest(doc);
    }

    protected final void initialize(VersioningFileSystemItemFactory factory, DocumentModel doc) throws ClientException {
        this.factory = factory;
        this.name = this.getFileName(doc);
        this.folder = false;
        this.updateDownloadURL();
        this.digestAlgorithm = "md5";
        this.updateDigest(doc);
        if (this.digest == null) {
            this.digestAlgorithm = null;
        }
        this.canUpdate = this.canRename;
    }

    protected BlobHolder getBlobHolder(DocumentModel doc) throws ClientException {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            throw new ClientException(String.format("Document %s is not a BlobHolder, it is not adaptable as a FileItem and therefore it cannot not be part of the items to synchronize.", doc.getId()));
        }
        return bh;
    }

    protected Blob getBlob(BlobHolder blobHolder) throws ClientException {
        Blob blob = blobHolder.getBlob();
        if (blob == null) {
            throw new ClientException("Document has no blob, it is not adaptable as a FileItem and therefore it cannot not be part of the items to synchronize.");
        }
        return blob;
    }

    protected Blob getBlob(DocumentModel doc) throws ClientException {
        BlobHolder bh = this.getBlobHolder(doc);
        return this.getBlob(bh);
    }

    protected String getFileName(DocumentModel doc) throws ClientException {
        String filename = this.getBlob(doc).getFilename();
        return filename != null ? filename : doc.getTitle();
    }

    protected void updateDocTitleIfNeeded(DocumentModel doc, String name) throws ClientException {
        if (this.name.equals(this.docTitle)) {
            doc.setPropertyValue("dc:title", (Serializable)((Object)name));
            this.docTitle = name;
        }
    }

    protected void updateDownloadURL() throws ClientException {
        StringBuilder downloadURLSb = new StringBuilder();
        downloadURLSb.append("nxbigfile/");
        downloadURLSb.append(this.repositoryName);
        downloadURLSb.append("/");
        downloadURLSb.append(this.docId);
        downloadURLSb.append("/");
        downloadURLSb.append("blobholder:0");
        downloadURLSb.append("/");
        String escapedFilename = this.name.replaceAll("(/|\\\\|\\*|<|>|\\?|\"|:|\\|)", "-");
        downloadURLSb.append(URIUtils.quoteURIPathComponent((String)escapedFilename, (boolean)true));
        this.downloadURL = downloadURLSb.toString();
    }

    protected void updateDigest(DocumentModel doc) throws ClientException {
        Blob blob = this.getBlob(doc);
        this.digest = FileSystemItemHelper.getDigest(blob, this.digestAlgorithm);
    }

    protected void versionIfNeeded(DocumentModel doc, CoreSession session) throws ClientException {
        if (this.factory.needsVersioning(doc)) {
            doc.putContextData("VersioningOption", (Serializable)this.factory.getVersioningOption());
            session.saveDocument(doc);
        }
    }

    protected NuxeoDriveManager getNuxeoDriveManager() {
        return (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
    }

    protected void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    protected void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    protected void setDigest(String digest) {
        this.digest = digest;
    }

    protected void setCanUpdate(boolean canUpdate) {
        this.canUpdate = canUpdate;
    }
}

