/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;

public final class FileSystemItemHelper {
    public static final String MD5_DIGEST_ALGORITHM = "md5";

    private FileSystemItemHelper() {
    }

    public static String getDigest(Blob blob, String digestAlgorithm) throws ClientException {
        String digest = blob.getDigest();
        if (StringUtils.isEmpty((String)digest)) {
            if (MD5_DIGEST_ALGORITHM.equals(digestAlgorithm)) {
                try {
                    digest = DigestUtils.md5Hex((InputStream)blob.getStream());
                }
                catch (IOException e) {
                    throw new ClientException(String.format("Error while computing digest for blob %s.", blob.getFilename()), (Throwable)e);
                }
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported digest algorithm %s.", digestAlgorithm));
            }
        }
        return digest;
    }
}

