/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageListCacheEntry;

public class PackageListCache {
    protected Map<String, PackageListCacheEntry> cache = new HashMap<String, PackageListCacheEntry>();
    protected int cache_duration = 5;

    public PackageListCache() {
        String cacheParam = NuxeoConnectClient.getProperty("org.nuxeo.ecm.connect.client.cache", "5");
        this.cache_duration = Integer.parseInt(cacheParam);
    }

    public void add(List<DownloadablePackage> pkgs, String type) {
        this.cache.put(type, new PackageListCacheEntry(pkgs));
    }

    public List<DownloadablePackage> getFromCache(String type) {
        long delta;
        PackageListCacheEntry entry = this.cache.get(type);
        if (entry != null && (delta = System.currentTimeMillis() - entry.getTimeStamp()) < (long)(this.cache_duration * 60 * 1000)) {
            return entry.getPackages();
        }
        return null;
    }
}

