/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.identity;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.identity.Base64;

public class TechnicalInstanceIdentifier {
    protected static final String HASH_METHOD = "MD5";
    protected String CTID;
    protected static TechnicalInstanceIdentifier instance;

    public static TechnicalInstanceIdentifier instance() {
        if (instance == null) {
            instance = new TechnicalInstanceIdentifier();
        }
        return instance;
    }

    protected String getOrBuildCTID() throws Exception {
        if (this.CTID != null) {
            return this.CTID;
        }
        String osName = System.getProperty("os.name");
        String instancePath = null;
        instancePath = NuxeoConnectClient.isTestModeSet() ? "TEST" : NuxeoConnectClient.getHomePath();
        String hwInfo = TechnicalInstanceIdentifier.generateHardwareUID();
        try {
            instancePath = Base64.encodeBytes(MessageDigest.getInstance(HASH_METHOD).digest(instancePath.getBytes()));
            hwInfo = Base64.encodeBytes(MessageDigest.getInstance(HASH_METHOD).digest(hwInfo.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            instancePath = "***";
            hwInfo = "***";
        }
        this.CTID = osName + "-" + instancePath + "-" + hwInfo;
        return this.CTID;
    }

    public String getCTID() throws Exception {
        return this.getOrBuildCTID();
    }

    public static String generateHardwareUID() throws Exception {
        String hwUID = "";
        String javaVersion = System.getProperty("java.version");
        Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
        block0: while (ifs.hasMoreElements()) {
            NetworkInterface ni = ifs.nextElement();
            if (javaVersion.contains("1.6")) {
                Method[] methods;
                for (Method method : methods = ni.getClass().getMethods()) {
                    if (!method.getName().equalsIgnoreCase("getHardwareAddress")) continue;
                    byte[] hwAddr = (byte[])method.invoke((Object)ni, new Object[0]);
                    if (hwAddr == null) continue block0;
                    hwUID = hwUID + "-" + Base64.encodeBytes(hwAddr);
                    continue block0;
                }
                continue;
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                hwUID = hwUID + "-" + Base64.encodeBytes(addrs.nextElement().getAddress());
            }
        }
        return hwUID;
    }
}

