/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryDescriptor;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class TopLevelFolderItemFactoryRegistry
extends ContributionFragmentRegistry<TopLevelFolderItemFactoryDescriptor> {
    private static final Log log = LogFactory.getLog(TopLevelFolderItemFactoryRegistry.class);
    protected static final String CONTRIBUTION_ID = "topLevelFolderItemFactoryContrib";
    protected TopLevelFolderItemFactory factory;

    public String getContributionId(TopLevelFolderItemFactoryDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, TopLevelFolderItemFactoryDescriptor contrib, TopLevelFolderItemFactoryDescriptor newOrigContrib) {
        try {
            log.trace((Object)String.format("Setting top level folder item factory to class %s", contrib.getName()));
            this.factory = contrib.getFactory();
        }
        catch (Exception e) {
            throw new ClientRuntimeException("Cannot update topLevelFolderItemFactory contribution.", (Throwable)e);
        }
    }

    public void contributionRemoved(String id, TopLevelFolderItemFactoryDescriptor origContrib) {
        log.trace((Object)"Removing top level folder item factory (setting it to null)");
        this.factory = null;
    }

    public TopLevelFolderItemFactoryDescriptor clone(TopLevelFolderItemFactoryDescriptor orig) {
        log.trace((Object)String.format("Cloning contribution with class name %s", orig.getName()));
        TopLevelFolderItemFactoryDescriptor clone = new TopLevelFolderItemFactoryDescriptor();
        clone.factoryClass = orig.factoryClass;
        return clone;
    }

    public void merge(TopLevelFolderItemFactoryDescriptor src, TopLevelFolderItemFactoryDescriptor dst) {
        log.trace((Object)String.format("Merging contribution with class name %s to contribution with class name %s", src.getName(), dst.getName()));
        if (src.getFactoryClass() != null && !src.getFactoryClass().equals(dst.getFactoryClass())) {
            dst.setFactoryClass(src.getFactoryClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getparameter(name));
            }
        }
    }
}

