/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.ecm.core.api.ClientException;

@XObject(value="fileSystemItemFactory")
public class FileSystemItemFactoryDescriptor
implements Serializable,
Comparable<FileSystemItemFactoryDescriptor> {
    private static final long serialVersionUID = -7840980495329452651L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNode(value="@order")
    protected int order = 0;
    @XNode(value="@docType")
    protected String docType;
    @XNode(value="@facet")
    protected String facet;
    @XNode(value="@class")
    protected Class<? extends FileSystemItemFactory> factoryClass;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> parameters = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public Class<? extends FileSystemItemFactory> getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(Class<? extends FileSystemItemFactory> factoryClass) {
        this.factoryClass = factoryClass;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getparameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public FileSystemItemFactory getFactory() throws InstantiationException, IllegalAccessException, ClientException {
        FileSystemItemFactory factory = this.factoryClass.newInstance();
        factory.setName(this.name);
        factory.handleParameters(this.parameters);
        return factory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        sb.append(this.getOrder());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(FileSystemItemFactoryDescriptor other) {
        if (other == null) {
            return 1;
        }
        int orderDiff = this.getOrder() - other.getOrder();
        if (orderDiff == 0) {
            orderDiff = this.getName().compareTo(other.getName());
        }
        return orderDiff;
    }
}

