/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.seam;

import java.io.File;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.common.Environment;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.seam.DesktopPackageDefinition;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.security.SecurityException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.ecm.user.center.UserCenterViewManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="nuxeoDriveActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class NuxeoDriveActions
implements Serializable {
    private static final Log log = LogFactory.getLog(NuxeoDriveActions.class);
    protected static final String IS_UNDER_SYNCHRONIZATION_ROOT = "nuxeoDriveIsUnderSynchronizationRoot";
    protected static final String CURRENT_SYNCHRONIZATION_ROOT = "nuxeoDriveCurrentSynchronizationRoot";
    private static final long serialVersionUID = 1L;
    public static final String NXDRIVE_PROTOCOL = "nxdrive";
    public static final String PROTOCOL_COMMAND_EDIT = "edit";
    @In(required=false)
    NavigationContext navigationContext;
    @In(required=false)
    CoreSession documentManager;
    @In(required=false, create=true)
    UserCenterViewManager userCenterViews;

    @Factory(value="nuxeoDriveCurrentSynchronizationRoot", scope=ScopeType.EVENT)
    public DocumentModel getCurrentSynchronizationRoot() throws ClientException {
        if (this.navigationContext == null || this.documentManager == null) {
            return null;
        }
        Context cache = Contexts.getEventContext();
        Boolean isUnderSync = (Boolean)cache.get(IS_UNDER_SYNCHRONIZATION_ROOT);
        if (isUnderSync == null) {
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
            Set references = driveManager.getSynchronizationRootReferences(this.documentManager);
            DocumentModelList path = this.navigationContext.getCurrentPath();
            DocumentModel root = null;
            for (DocumentModel parent : path) {
                if (!references.contains(parent.getRef())) continue;
                root = parent;
                break;
            }
            cache.set(CURRENT_SYNCHRONIZATION_ROOT, root);
            cache.set(IS_UNDER_SYNCHRONIZATION_ROOT, (Object)(root != null ? 1 : 0));
        }
        return (DocumentModel)cache.get(CURRENT_SYNCHRONIZATION_ROOT);
    }

    @Factory(value="canEditCurrentDocument", scope=ScopeType.EVENT)
    public boolean canEditCurrentDocument() throws ClientException {
        if (this.getCurrentSynchronizationRoot() == null || this.navigationContext == null || this.documentManager == null || this.navigationContext.getCurrentDocument() == null) {
            return false;
        }
        BlobHolder blobHolder = (BlobHolder)this.navigationContext.getCurrentDocument().getAdapter(BlobHolder.class);
        return blobHolder != null && blobHolder.getBlob() != null;
    }

    public String getDriveEditURL() throws ClientException {
        FileSystemItemAdapterService fsAdapterService = (FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class);
        FileSystemItem fileSystemItem = fsAdapterService.getFileSystemItem(this.navigationContext.getCurrentDocument());
        if (fileSystemItem == null) {
            log.warn((Object)String.format("Failed to adapt '%s' to generate drive edit link", this.navigationContext.getCurrentDocument().getTitle()));
            return "";
        }
        String fsItemId = fileSystemItem.getId();
        ServletRequest servletRequest = (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)servletRequest);
        StringBuffer sb = new StringBuffer();
        sb.append(NXDRIVE_PROTOCOL).append("://");
        sb.append(PROTOCOL_COMMAND_EDIT).append("/");
        sb.append(baseURL.replaceFirst("://", "/"));
        sb.append("fsitem/");
        sb.append(fsItemId);
        return sb.toString();
    }

    @Factory(value="canSynchronizeCurrentDocument", scope=ScopeType.EVENT)
    public boolean getCanSynchronizeCurrentDocument() throws ClientException {
        if (this.navigationContext == null) {
            return false;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!currentDocument.isFolder()) {
            return false;
        }
        boolean hasPermission = this.documentManager.hasPermission(currentDocument.getRef(), "AddChildren");
        if (!hasPermission) {
            return false;
        }
        return this.getCurrentSynchronizationRoot() == null;
    }

    @Factory(value="canUnSynchronizeCurrentDocument", scope=ScopeType.EVENT)
    public boolean getCanUnSynchronizeCurrentDocument() throws ClientException {
        if (this.navigationContext == null) {
            return false;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot();
        if (currentSyncRoot == null) {
            return false;
        }
        return currentDocRef.equals(currentSyncRoot.getRef());
    }

    @Factory(value="canNavigateToCurrentSynchronizationRoot", scope=ScopeType.EVENT)
    public boolean getCanNavigateToCurrentSynchronizationRoot() throws ClientException {
        if (this.navigationContext == null) {
            return false;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot();
        if (currentSyncRoot == null) {
            return false;
        }
        return !currentDocRef.equals(currentSyncRoot.getRef());
    }

    @Factory(value="currentDocumentUserWorkspace", scope=ScopeType.PAGE)
    public boolean isCurrentDocumentUserWorkspace() throws ClientException {
        if (this.navigationContext == null) {
            return false;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return UserWorkspaceHelper.isUserWorkspace((DocumentModel)currentDocument);
    }

    public String synchronizeCurrentDocument() throws ClientException, SecurityException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Principal principal = this.documentManager.getPrincipal();
        String userName = principal.getName();
        DocumentModel newSyncRoot = this.navigationContext.getCurrentDocument();
        driveManager.registerSynchronizationRoot(principal, newSyncRoot, this.documentManager);
        TokenAuthenticationService tokenService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
        boolean hasOneNuxeoDriveToken = false;
        for (DocumentModel token : tokenService.getTokenBindings(userName)) {
            if (!"Nuxeo Drive".equals(token.getPropertyValue("authtoken:applicationName"))) continue;
            hasOneNuxeoDriveToken = true;
            break;
        }
        if (hasOneNuxeoDriveToken) {
            return null;
        }
        this.userCenterViews.setCurrentViewId("userCenterNuxeoDrive");
        return "view_home";
    }

    public void unsynchronizeCurrentDocument() throws ClientException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Principal principal = this.documentManager.getPrincipal();
        DocumentModel syncRoot = this.navigationContext.getCurrentDocument();
        driveManager.unregisterSynchronizationRoot(principal, syncRoot, this.documentManager);
    }

    public String navigateToCurrentSynchronizationRoot() throws ClientException {
        DocumentModel currentRoot = this.getCurrentSynchronizationRoot();
        if (currentRoot == null) {
            return "";
        }
        return this.navigationContext.navigateToDocument(currentRoot);
    }

    public DocumentModelList getSynchronizationRoots() throws ClientException {
        DocumentModelListImpl syncRoots = new DocumentModelListImpl();
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Set syncRootRefs = driveManager.getSynchronizationRootReferences(this.documentManager);
        for (IdRef syncRootRef : syncRootRefs) {
            syncRoots.add((Object)this.documentManager.getDocument((DocumentRef)syncRootRef));
        }
        return syncRoots;
    }

    public void unsynchronizeRoot(DocumentModel syncRoot) throws ClientException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Principal principal = this.documentManager.getPrincipal();
        driveManager.unregisterSynchronizationRoot(principal, syncRoot, this.documentManager);
    }

    @Factory(value="nuxeoDriveClientPackages", scope=ScopeType.CONVERSATION)
    public List<DesktopPackageDefinition> getClientPackages() {
        ArrayList<DesktopPackageDefinition> packages = new ArrayList<DesktopPackageDefinition>();
        File clientDir = new File(Environment.getDefault().getServerHome(), "client");
        if (clientDir.isDirectory()) {
            for (File file : clientDir.listFiles()) {
                String fileName = file.getName();
                boolean isDesktopPackage = false;
                String platform = null;
                if (fileName.endsWith(".msi")) {
                    isDesktopPackage = true;
                    platform = "windows";
                } else if (fileName.endsWith(".dmg")) {
                    isDesktopPackage = true;
                    platform = "osx";
                } else if (fileName.endsWith(".deb")) {
                    isDesktopPackage = true;
                    platform = "ubuntu";
                }
                if (!isDesktopPackage) continue;
                packages.add(new DesktopPackageDefinition(file, fileName, platform));
                log.debug((Object)String.format("Added %s to the list of desktop packages available for download.", fileName));
            }
        }
        packages.add(new DesktopPackageDefinition("https://github.com/nuxeo/nuxeo-drive/#ubuntudebian-and-other-linux-variants-client", "user.center.nuxeoDrive.platform.ubuntu.docLinkTitle", "ubuntu"));
        return packages;
    }

    public String downloadClientPackage(String name, File file) {
        FacesContext facesCtx = FacesContext.getCurrentInstance();
        return ComponentUtils.downloadFile((FacesContext)facesCtx, (String)name, (File)file);
    }
}

