/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryWrapper;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class FileSystemItemFactoryRegistry
extends ContributionFragmentRegistry<FileSystemItemFactoryDescriptor> {
    private static final Log log = LogFactory.getLog(FileSystemItemFactoryRegistry.class);
    protected final Map<String, FileSystemItemFactoryDescriptor> factoryDescriptors = new HashMap<String, FileSystemItemFactoryDescriptor>();

    public String getContributionId(FileSystemItemFactoryDescriptor contrib) {
        String name = contrib.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new ClientRuntimeException("Cannot register fileSystemItemFactory without a name.");
        }
        return name;
    }

    public void contributionUpdated(String id, FileSystemItemFactoryDescriptor contrib, FileSystemItemFactoryDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            log.trace((Object)String.format("Putting contribution %s with id %s in factory descriptors", contrib, id));
            this.factoryDescriptors.put(id, contrib);
        } else {
            log.trace((Object)String.format("Removing disabled contribution with id %s from factory descriptors", id));
            this.factoryDescriptors.remove(id);
        }
    }

    public void contributionRemoved(String id, FileSystemItemFactoryDescriptor origContrib) {
        log.trace((Object)String.format("Removing contribution with id %s from factory descriptors", id));
        this.factoryDescriptors.remove(id);
    }

    public FileSystemItemFactoryDescriptor clone(FileSystemItemFactoryDescriptor orig) {
        log.trace((Object)String.format("Cloning contribution with id %s", orig.getName()));
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(orig);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (FileSystemItemFactoryDescriptor)ois.readObject();
        }
        catch (Exception e) {
            throw new ClientRuntimeException("Cannot clone contribution " + orig, (Throwable)e);
        }
    }

    public void merge(FileSystemItemFactoryDescriptor src, FileSystemItemFactoryDescriptor dst) {
        log.trace((Object)String.format("Merging contribution with id %s to contribution with id %s", src.getName(), dst.getName()));
        if (src.isEnabled() != dst.isEnabled()) {
            dst.setEnabled(src.isEnabled());
        }
        if (src.getOrder() != dst.getOrder()) {
            dst.setOrder(src.getOrder());
        }
        if (!StringUtils.isEmpty((String)src.getDocType()) && !src.getDocType().equals(dst.getDocType())) {
            dst.setDocType(src.getDocType());
        }
        if (!StringUtils.isEmpty((String)src.getFacet()) && !src.getFacet().equals(dst.getFacet())) {
            dst.setFacet(src.getFacet());
        }
        if (src.getFactoryClass() != null && !src.getFactoryClass().equals(dst.getFactoryClass())) {
            dst.setFactoryClass(src.getFactoryClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getparameter(name));
            }
        }
    }

    protected List<FileSystemItemFactoryWrapper> getOrderedFactories() throws Exception {
        ArrayList<FileSystemItemFactoryWrapper> factories = new ArrayList<FileSystemItemFactoryWrapper>();
        ArrayList<FileSystemItemFactoryDescriptor> orderedFactoryDescriptors = new ArrayList<FileSystemItemFactoryDescriptor>(this.factoryDescriptors.values());
        Collections.sort(orderedFactoryDescriptors);
        for (FileSystemItemFactoryDescriptor factoryDesc : orderedFactoryDescriptors) {
            FileSystemItemFactoryWrapper factoryWrapper = new FileSystemItemFactoryWrapper(factoryDesc.getDocType(), factoryDesc.getFacet(), factoryDesc.getFactory());
            factories.add(factoryWrapper);
        }
        return factories;
    }
}

