/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.FileSystemItemChange;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class AuditChangeFinder
implements FileSystemChangeFinder {
    private static final long serialVersionUID = 1963018967324857522L;
    private static final Log log = LogFactory.getLog(AuditChangeFinder.class);

    @Override
    public List<FileSystemItemChange> getFileSystemChanges(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, long lastSuccessfulSyncDate, long syncDate, int limit) throws ClientException, TooManyChangesException {
        String principalName = session.getPrincipal().getName();
        ArrayList<FileSystemItemChange> changes = new ArrayList<FileSystemItemChange>();
        if (!activeRoots.paths.isEmpty() || !lastActiveRootRefs.isEmpty()) {
            AuditReader auditService = (AuditReader)Framework.getLocalService(AuditReader.class);
            StringBuilder auditQuerySb = new StringBuilder();
            auditQuerySb.append("log.repositoryId = '");
            auditQuerySb.append(session.getRepositoryName());
            auditQuerySb.append("' and ");
            auditQuerySb.append("(");
            if (!activeRoots.paths.isEmpty()) {
                auditQuerySb.append("(");
                auditQuerySb.append("log.category = 'eventDocumentCategory'");
                auditQuerySb.append(" and (log.eventId = 'documentCreated' or log.eventId = 'documentModified' or log.eventId = 'documentMoved')");
                auditQuerySb.append(" or ");
                auditQuerySb.append("log.category = 'eventLifeCycleCategory'");
                auditQuerySb.append(" and log.eventId = 'lifecycle_transition_event' and log.docLifeCycle != 'deleted' ");
                auditQuerySb.append(" or ");
                auditQuerySb.append("log.category = '");
                auditQuerySb.append(NuxeoDriveEvents.EVENT_CATEGORY);
                auditQuerySb.append("'");
                auditQuerySb.append(") and (");
                auditQuerySb.append(this.getCurrentRootFilteringClause(activeRoots.paths));
                auditQuerySb.append(")");
            }
            if (!activeRoots.paths.isEmpty() && !lastActiveRootRefs.isEmpty()) {
                auditQuerySb.append("or ");
            }
            if (!lastActiveRootRefs.isEmpty()) {
                auditQuerySb.append("log.category = '");
                auditQuerySb.append(NuxeoDriveEvents.EVENT_CATEGORY);
                auditQuerySb.append("' and ");
                auditQuerySb.append(this.getLastRootFilteringClause(lastActiveRootRefs));
            }
            auditQuerySb.append(") and (");
            auditQuerySb.append(this.getJPADateClause(lastSuccessfulSyncDate, syncDate));
            auditQuerySb.append(") order by log.repositoryId asc, log.eventDate desc");
            String auditQuery = auditQuerySb.toString();
            log.debug((Object)("Querying audit logs for document changes: " + auditQuery));
            List entries = auditService.nativeQueryLogs(auditQuery, 1, limit);
            if (entries.size() >= limit) {
                throw new TooManyChangesException("Too many changes found in the audit logs.");
            }
            for (LogEntry entry : entries) {
                DocumentModel doc;
                FileSystemItem fsItem;
                ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
                if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
                ExtendedInfo fsIdInfo = (ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemId");
                if (fsIdInfo != null) {
                    String fsId = (String)fsIdInfo.getValue(String.class);
                    String fsName = (String)((ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemName")).getValue(String.class);
                    FileSystemItemChange change = new FileSystemItemChange(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsId, fsName);
                    changes.add(change);
                    continue;
                }
                IdRef docRef = new IdRef(entry.getDocUUID());
                if (!session.exists((DocumentRef)docRef) || (fsItem = (FileSystemItem)(doc = session.getDocument((DocumentRef)docRef)).getAdapter(FileSystemItem.class)) == null) continue;
                FileSystemItemChange change = new FileSystemItemChange(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsItem);
                changes.add(change);
            }
        }
        return changes;
    }

    protected String getCurrentRootFilteringClause(Set<String> rootPaths) {
        StringBuilder rootPathClause = new StringBuilder();
        for (String rootPath : rootPaths) {
            if (rootPathClause.length() > 0) {
                rootPathClause.append(" or ");
            }
            rootPathClause.append(String.format("log.docPath like '%s%%'", rootPath));
        }
        return rootPathClause.toString();
    }

    protected String getLastRootFilteringClause(Set<IdRef> lastActiveRootRefs) {
        StringBuilder rootPathClause = new StringBuilder();
        if (!lastActiveRootRefs.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>();
            for (IdRef ref : lastActiveRootRefs) {
                ids.add(ref.toString());
            }
            rootPathClause.append("log.docUUID in ('");
            rootPathClause.append(StringUtils.join(ids, (String)"', '"));
            rootPathClause.append("')");
        }
        return rootPathClause.toString();
    }

    protected String getJPADateClause(long lastSuccessfulSyncDate, long syncDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return String.format("log.eventDate >= '%s' and log.eventDate < '%s'", sdf.format(new Date(lastSuccessfulSyncDate)), sdf.format(new Date(syncDate)));
    }

    protected boolean adaptDocument(FileSystemItemChange change, CoreSession session, SynchronizationRoots synchronizationRoots) throws ClientException {
        IdRef ref = new IdRef(change.getDocUuid());
        try {
            DocumentModel doc = session.getDocument((DocumentRef)ref);
            FileSystemItem fsItem = (FileSystemItem)doc.getAdapter(FileSystemItem.class);
            if (fsItem == null) {
                return false;
            }
            change.setFileSystemItem(fsItem);
            return true;
        }
        catch (DocumentSecurityException e) {
            return false;
        }
    }
}

