/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.io.Serializable;
import java.security.Principal;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.TimeZone;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDriveFileSystemDeletionListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if ("aboutToRemove".equals(event.getName()) && "deleted".equals(doc.getCurrentLifeCycleState())) {
            return;
        }
        String transition = (String)((Object)ctx.getProperty("transition"));
        if (transition != null && !"delete".equals(transition)) {
            return;
        }
        String impactedUserName = (String)((Object)ctx.getProperty("impactedUserName"));
        try {
            this.logDeletionEvent(doc, ctx.getPrincipal(), impactedUserName);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void logDeletionEvent(DocumentModel doc, Principal principal, String impactedUserName) throws ClientException {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger == null) {
            return;
        }
        FileSystemItem fsItem = null;
        try {
            fsItem = ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, true);
        }
        catch (RootlessItemException e) {
            return;
        }
        if (fsItem == null) {
            return;
        }
        LogEntry entry = logger.newLogEntry();
        entry.setEventId("deleted");
        entry.setEventDate(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime());
        entry.setCategory((String)((Object)NuxeoDriveEvents.EVENT_CATEGORY));
        entry.setDocUUID(doc.getId());
        entry.setDocPath(doc.getPathAsString());
        entry.setPrincipalName(principal.getName());
        entry.setDocType(doc.getType());
        entry.setRepositoryId(doc.getRepositoryName());
        entry.setDocLifeCycle(doc.getCurrentLifeCycleState());
        HashMap<String, ExtendedInfo> extendedInfos = new HashMap<String, ExtendedInfo>();
        if (impactedUserName != null) {
            extendedInfos.put("impactedUserName", logger.newExtendedInfo((Serializable)((Object)impactedUserName)));
        }
        extendedInfos.put("fileSystemItemId", logger.newExtendedInfo((Serializable)((Object)fsItem.getId())));
        extendedInfos.put("fileSystemItemName", logger.newExtendedInfo((Serializable)((Object)fsItem.getName())));
        entry.setExtendedInfos(extendedInfos);
        logger.addLogEntries(Collections.singletonList(entry));
    }
}

