# nuxeo-docaposte-fast-parapheur

Nuxeo / Docaposte FAST Parapheur connector.
The project objective is to build a Nuxeo marketplace which purpose is to integrate Docaposte FAST Parapheur's features to a Nuxeo instance.

## Target Platform
Nuxeo Platform **10.10**

## Requirements
Java Version: **1.8**

## Build
`mvn clean install`

The building process creates two marketplaces :
* in nuxeo-docaposte-fast-parapheur-package/target lies the connector marketplace itself
* in demo-nuxeo-docaposte-fast-parapheur-package/target lies the demo marketplace (cf. deployment following deployment section)

## Deployment (demo)
After build, run the following commands to install (assuming `$NUXEO_HOME` exists, otherwise go to the appropriate folder):
```sh
$NUXEO_HOME/bin/nuxeoctl stop
$NUXEO_HOME/bin/nuxeoctl mp-install <path_to_the_connector_generation_folder>/nuxeo-docaposte-fast-parapheur-package-<version>.zip <path_to_the_demo_generation_folder>/demo-nuxeo-docaposte-fast-parapheur-package-<version>.zip
$NUXEO_HOME/bin/nuxeoctl start
```

No further configuration is required.

## Deployment (prod)
After build, run the following commands to install (assuming `$NUXEO_HOME` exists, otherwise go to the appropriate folder):
```sh
$NUXEO_HOME/bin/nuxeoctl stop
$NUXEO_HOME/bin/nuxeoctl mp-install <path_to_the_connector_generation_folder>/nuxeo-docaposte-fast-parapheur-package-<version>.zip
$NUXEO_HOME/bin/nuxeoctl start
```

Once the package is installed, go to [Nuxeo OCDM Connectors administration page](http://localhost:8080/nuxeo/ui/#!/admin/ocdm-connectors). Copy the request key and use it to [generate a license key](http://10.20.0.55/composants-nuxeo/nuxeo-marketplace-licence-toolkit/blob/master/nuxeo-marketplace-licence-generator/README.md) for the app "fast-parapheur".

You then need to configure Nuxeo so that the connector works properly. There are several ways to do that, they are listed below.

### Note about the truststore and the keystore
In the configurations below:
- the truststore needs to contain at least the certificate from docapost-fast.fr, the one for connect.nuxeo.com is necessary in order to keep features such as hot reload working
- the keystore needs to contain at least the certificate Agent from Docaposte FAST Parapheur

The following commands can be used to create or edit a truststore and a keystore:

```sh
# Truststore (can be used to create a new store or import in an existing store)
keytool -import -trustcacerts -alias <alias> -file <src_file> -storetype <store_type> -keystore <dest_file>

# Keystore (can be used to create a new store or import in an existing store)
keytool -importkeystore -srckeystore <src_file> -srcstoretype <src_store_type> -destkeystore <dest_file> -deststoretype <dest_store_type> -deststorepass <dest_store_password> -destkeypass <dest_key_pass>
```

### Configuration option 1: custom properties with encryption in `nuxeo.conf` 
*This is the most secure option, since the truststore and keystore passwords are encrypted.*

Edit `$NUXEO_HOME/bin/nuxeo.conf`, add the following properties:

| []()                                                     | []()                     |
|----------------------------------------------------------|--------------------------|
| `connector.docaposte.fast.parapheur.url`                 | Docaposte webservice URL |
| `connector.docaposte.fast.parapheur.subscriber`          | Docaposte subscriber ID  |
| `connector.docaposte.fast.parapheur.license`             | OCDM connector license   |
| `connector.docaposte.fast.parapheur.truststore.path`     | Truststore path          |
| `connector.docaposte.fast.parapheur.truststore.type`     | Truststore type          |
| `connector.docaposte.fast.parapheur.keystore.path`       | Keystore path            |
| `connector.docaposte.fast.parapheur.keystore.type`       | Keystore type            |

Then [prepare and encrypt](https://doc.nuxeo.com/nxdoc/sensitive-configuration-data-encryption/) the two following properties:

| []()                                                     | []()                     |
|----------------------------------------------------------|--------------------------|
| `connector.docaposte.fast.parapheur.truststore.password` | Truststore password      |
| `connector.docaposte.fast.parapheur.keystore.password`   | Keystore password        |

Then restart the server.

#### Example
```
##-----------------------------------------------------------------------------
## OCDM Connectors
##-----------------------------------------------------------------------------
connector.docaposte.fast.parapheur.url=https://demo-parapheur.dfast.fr/parapheur-soap/soap/v1/Documents?wsdl
connector.docaposte.fast.parapheur.subscriber=999100059
connector.docaposte.fast.parapheur.license=mGT+mSdtDxaYHYD9lgAUVE90TC7ove/8kzpMANgnArgI5Ayhsod2Q5hbOL9CzQ/nTiD9Qiy4ha93ugLkCs9ALNFnU2qKeD+ol34fcZAlK0Q=
connector.docaposte.fast.parapheur.truststore.path=conf/certs/docapostefast-connector-truststore.jks
connector.docaposte.fast.parapheur.truststore.type=jks
connector.docaposte.fast.parapheur.keystore.path=conf/certs/OCDM_Agent_089324.p12
connector.docaposte.fast.parapheur.keystore.type=pkcs12
```
```
### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###
#connector.docaposte.fast.parapheur.keystore.password=
connector.docaposte.fast.parapheur.keystore.password={$$xTwSk9pKwah/9bM9QqthtA==}
#connector.docaposte.fast.parapheur.truststore.password=
connector.docaposte.fast.parapheur.truststore.password={$$xTwSk9pKwah/9bM9QqthtA==}
#server.status.key=
server.status.key=5ae126bf
### END - DO NOT EDIT BETWEEN BEGIN AND END ###
```

### Configuration option 2: extension contribution
*With this option, the truststore and keystore passwords can be read by whoever can read the contribution.*

Create a contribution to the target `com.ocdm.connectors.nuxeo.docaposte.fast.parapheur.service.DFParapheurService` and to the point `parapheur-connector`.

Attributes are:

| []()                               | []()                     |
|------------------------------------|--------------------------|
| configuration > url                | Docaposte webservice URL |
| configuration > subscriber         | Docaposte subscriber ID  |
| configuration > license            | OCDM connector license   |
| configuration > truststorePath     | Truststore path          |
| configuration > truststoreType     | Truststore type          |
| configuration > truststorePassword | Truststore password      |
| configuration > keystorePath       | Keystore path            |
| configuration > keystoreType       | Keystore type            |
| configuration > keystorePassword   | Keystore password        |

Then restart the server.

#### Example
```xml
<configuration>
    <url>https://demo-parapheur.dfast.fr/parapheur-soap/soap/v1/Documents?wsdl</url>
    <subscriber>999100059</subscriber>
    <license>mGT+mSdtDxaYHYD9lgAUVE90TC7ove/8kzpMANgnArgI5Ayhsod2Q5hbOL9CzQ/nTiD9Qiy4ha93ugLkCs9ALNFnU2qKeD+ol34fcZAlK0Q=</license>
    <truststorePath>conf/certs/docapostefast-connector-truststore.jks</truststorePath>
    <truststoreType>jks</truststoreType>
    <truststorePassword>fastpwd</truststorePassword>
    <keystorePath>conf/certs/OCDM_Agent_089324.p12</keystorePath>
    <keystoreType>pkcs12</keystoreType>
    <keystorePassword>fastpwd</keystorePassword>
</configuration>
```

### Configuration option 3: custom properties and JAVA properties in `nuxeo.conf`
*This is the least secure option, the truststore and keystore passwords can be read by running a command like `ps -aux | grep java.net.ssl` on the server.*

Edit `$NUXEO_HOME/bin/nuxeo.conf`, add the following properties:

| []()                                                                                                                                                                          | []()                               |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------|
| `connector.docaposte.fast.parapheur.url`                                                                                                                                      | Docaposte webservice URL           |
| `connector.docaposte.fast.parapheur.subscriber`                                                                                                                               | Docaposte subscriber ID            |
| `connector.docaposte.fast.parapheur.license`                                                                                                                                  | OCDM connector license             |
| `JAVA_OPTS=$JAVA_OPTS -Djavax.net.ssl.trustStore=<truststore_path> -Djavax.net.ssl.trustStoreType=<truststore_type> -Djavax.net.ssl.trustStorePassword=<truststore_password>` | Truststore path, type and password |
| `JAVA_OPTS=$JAVA_OPTS -Djavax.net.ssl.keyStore=<keystore_path> -Djavax.net.ssl.keyStoreType=<keystore_type> -Djavax.net.ssl.keyStorePassword=<keystore_password>`             | Keystore path, type and password   |

Then restart the server.

#### Example
```
# Truststore
JAVA_OPTS=$JAVA_OPTS -Djavax.net.ssl.trustStore=conf/certs/docapostefast-connector-truststore.jks -Djavax.net.ssl.trustStoreType=jks -Djavax.net.ssl.trustStorePassword=fastpwd

# Keystore
JAVA_OPTS=$JAVA_OPTS -Djavax.net.ssl.keyStore=conf/certs/OCDM_Agent_089324.p12 -Djavax.net.ssl.keyStoreType=pkcs12 -Djavax.net.ssl.keyStorePassword=fastpwd
```
```
##-----------------------------------------------------------------------------
## OCDM Connectors
##-----------------------------------------------------------------------------
connector.docaposte.fast.parapheur.url=https://demo-parapheur.dfast.fr/parapheur-soap/soap/v1/Documents?wsdl
connector.docaposte.fast.parapheur.subscriber=999100059
connector.docaposte.fast.parapheur.license=mGT+mSdtDxaYHYD9lgAUVE90TC7ove/8kzpMANgnArgI5Ayhsod2Q5hbOL9CzQ/nTiD9Qiy4ha93ugLkCs9ALNFnU2qKeD+ol34fcZAlK0Q=
```

### Configuration option 4 (untested): default Java keystore and truststore
It should be possible to use Java default keystore and truststore instead of providing them in the package. In that case only the URL, the subscriber ID and the license should be provided in the configuration using one of the 3 previous options.

## Contributors
Florian TEYSSIER, from a POC by Billy KHOUMRI.
