/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core.impl;

import org.nuxeo.gwt.habyt.upload.client.core.InputFileWrapper;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.ui.Widget;

/**
 * Use a hidden input file which will replace the click widget when clicked.
 * (see gmail composer when flash is disabled). Should work on most javascript
 * enabled browsers.
 * 
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class SimpleInputFileWrapper extends InputFileWrapper implements
        ClickHandler {

    public SimpleInputFileWrapper() {
    }

    public void setVisibleWidget(Widget w) {
        super.setVisibleWidget(w);
        fu.setVisible(false);
        if (w instanceof HasClickHandlers == false) {
            throw new IllegalArgumentException(
                    "File widget not supported - it must implement HasClickHandlers");
        }
        ((HasClickHandlers) w).addClickHandler(this);
    }

    public void dispose() {
    }

    @Override
    public void onClick(ClickEvent event) {
        widget.setVisible(false);
        fu.setVisible(true);
    }

}
