/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core;

import org.nuxeo.gwt.habyt.upload.client.FileRef;
import org.nuxeo.gwt.habyt.upload.client.FileWidgetProvider;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class SimpleUpload extends AbstractUploadWidget {

    public SimpleUpload(String baseUrl) {
        this(baseUrl, null);
    }

    public SimpleUpload(String baseUrl, FileWidgetProvider provider) {
        super(baseUrl, provider);
    }

    public void setFile(FileRef file) {
        files.addFile(file);
        uploader.getWidget().setVisible(false);
    }

    @Override
    public boolean isMultiUpload() {
        return false;
    }

}
