/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core;

import java.util.Iterator;

import org.nuxeo.gwt.habyt.upload.client.FileRef;
import org.nuxeo.gwt.habyt.upload.client.FileView;
import org.nuxeo.gwt.habyt.upload.client.FilesView;
import org.nuxeo.gwt.habyt.upload.client.Uploader;

import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class DefaultFilesView extends FilesView {

    public DefaultFilesView() {
        super();
    }

    public DefaultFilesView(Uploader uploader) {
        super(uploader);
    }

    public Panel getPanel() {
        return (Panel) getWidget();
    }

    @Override
    protected DefaultFileView createFileView(FileRef file) {
        return new DefaultFileView(uploader, file);
    }

    @Override
    protected Widget createWidget() {
        return new VerticalPanel();
    }

    @Override
    protected void addFileView(FileView view) {
        getPanel().add(view);
    }

    @Override
    public FileView getFileView(FileRef file) {
        Iterator<Widget> it = getPanel().iterator();
        while (it.hasNext()) {
            Widget w = it.next();
            if (w instanceof FileView) {
                FileView view = (FileView) w;
                if (file.equals(view.getFile())) {
                    return view;
                }
            }
        }
        return null;
    }

}
