/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Text;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.EventListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Utils;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPathUtil;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator.DecoratorVisitor;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.listener.AnnotationPopupEventListener;

public class NuxeoDecoratorVisitor
implements DecoratorVisitor {
    protected boolean decorating;
    protected final Node startNode;
    protected final Node endNode;
    protected boolean started;
    protected int startOffset;
    protected int endOffset;
    protected final Annotation annotation;
    protected final AnnotationController controller;
    protected boolean endNodeFound = false;
    protected boolean endNodeBeforeStartNode = false;
    protected Node currentNode;

    public NuxeoDecoratorVisitor(Annotation annotation, AnnotationController controller) {
        this.annotation = annotation;
        this.controller = controller;
        XPathUtil xpathUtil = new XPathUtil();
        Document document = Document.get();
        this.startNode = xpathUtil.getNode(annotation.getStartContainer().getXpath(), document).get(0);
        this.startOffset = annotation.getStartContainer().getOffset();
        this.endNode = xpathUtil.getNode(annotation.getEndContainer().getXpath(), document).get(0);
        this.endOffset = annotation.getEndContainer().getOffset();
        Log.debug((String)("Decorator -- start node: " + this.startNode + ";text: " + ((com.google.gwt.dom.client.Element)this.startNode).getInnerHTML() + ";parent html: " + ((Element)this.startNode.getParentNode()).getInnerHTML()));
        Log.debug((String)("Decorator -- end node: " + this.endNode + ";text: " + ((com.google.gwt.dom.client.Element)this.endNode).getInnerHTML() + ";parent html: " + ((Element)this.endNode.getParentNode()).getInnerHTML()));
        Log.debug((String)("Decorator -- start offset: " + this.startOffset + "; end offset: " + this.endOffset));
    }

    @Override
    public void process(Node node) {
        this.currentNode = node;
        this.checkEndNodeBeforeStartNode();
        this.shouldStartProcess();
        this.processNodeIfStarted();
    }

    protected void checkEndNodeBeforeStartNode() {
        if (this.started || this.startNode.equals((Object)this.endNode)) {
            return;
        }
        if (this.currentNode.equals((Object)this.endNode)) {
            Log.debug((String)"Decorator -- EndNodeBeforeStartNode found.");
            this.endNodeBeforeStartNode = true;
        }
    }

    protected void shouldStartProcess() {
        if (this.currentNode.equals((Object)this.startNode) && !this.started) {
            Log.debug((String)("Decorator -- start node found: " + this.currentNode + ";text: " + this.currentNode.getNodeValue()));
            Log.debug((String)("Decorator -- parent html: " + ((Element)this.currentNode.getParentNode()).getInnerHTML()));
            this.started = true;
            if (this.startNode.equals((Object)this.endNode)) {
                this.endNodeFound = true;
            }
        }
    }

    protected void processNodeIfStarted() {
        if (this.started) {
            this.processNode();
        }
    }

    protected void processNode() {
        if (!this.decorating) {
            this.processToFirstNode();
        } else {
            this.decorateNode();
        }
    }

    protected void processToFirstNode() {
        Log.debug((String)("Decorator -- processToFirstNode: " + this.currentNode.getNodeName()));
        if (this.currentNode.getNodeType() != 3) {
            return;
        }
        Text text = (Text)this.currentNode;
        String data = text.getData();
        Log.debug((String)("Decorator -- text data before: " + data));
        data = Utils.removeWhitespaces(data, this.currentNode);
        Log.debug((String)("Decorator -- text data after: " + data));
        if (data.length() < this.startOffset) {
            this.startOffset -= data.length();
            if (this.startNode.equals((Object)this.endNode)) {
                this.endOffset -= data.length();
            }
            return;
        }
        this.decorating = true;
        String notInData = data.substring(0, this.startOffset);
        this.decorateText(data.substring(this.startOffset));
        text.setData(notInData);
    }

    protected void decorateText(String textToDecorate) {
        this.checkEndNodeFound();
        String afterText = this.getAfterText();
        Log.debug((String)("Decorator -- afterText: " + afterText));
        if (afterText.length() > 0) {
            textToDecorate = textToDecorate.substring(0, textToDecorate.length() - afterText.length());
        }
        if (this.currentNode.getParentNode().getNodeName().equalsIgnoreCase("tr")) {
            return;
        }
        com.google.gwt.dom.client.Element spanElement = this.decorateTextWithSpan(textToDecorate);
        if (spanElement == null) {
            if (afterText.length() > 0) {
                Document document = this.currentNode.getOwnerDocument();
                Node parent = this.currentNode.getParentNode();
                this.insertBefore(parent, this.currentNode, (Node)document.createTextNode(afterText));
            }
        } else {
            Log.debug((String)("Decorator -- span element: " + spanElement.getInnerHTML()));
            if (afterText.length() > 0) {
                Document document = this.currentNode.getOwnerDocument();
                Node parent = this.currentNode.getParentNode();
                this.insertBefore(parent, spanElement.getNextSibling(), (Node)document.createTextNode(afterText));
            }
        }
    }

    protected void checkEndNodeFound() {
        Log.debug((String)("Decorator -- endNode: " + this.endNode));
        Log.debug((String)("Decorator -- currentNode: " + this.currentNode));
        Log.debug((String)("Decorator -- endNode == currentNode?: " + this.currentNode.equals((Object)this.endNode)));
        if (this.currentNode.equals((Object)this.endNode)) {
            this.endNodeFound = true;
            Log.debug((String)("Decorator -- end node found: " + this.currentNode + ";text: " + this.currentNode.getNodeValue()));
            Log.debug((String)("Decorator -- parent html: " + ((Element)this.currentNode.getParentNode()).getInnerHTML()));
        }
    }

    protected String getAfterText() {
        Text text = (Text)this.currentNode;
        String data = text.getData();
        Log.debug((String)("Decorator -- text data before: " + data));
        data = Utils.removeWhitespaces(data, this.currentNode);
        Log.debug((String)("Decorator -- text data after: " + data));
        String afterText = "";
        if (this.endNodeFound) {
            if (data.length() > this.endOffset) {
                afterText = data.substring(this.endOffset);
                data = data.substring(0, this.endOffset);
            }
            this.endOffset -= data.length();
        }
        return afterText;
    }

    protected com.google.gwt.dom.client.Element decorateTextWithSpan(String data) {
        String parentClassName;
        if (data.trim().length() == 0) {
            return null;
        }
        Document document = this.currentNode.getOwnerDocument();
        SpanElement spanElement = this.getSpanElement(document);
        spanElement.setInnerText(data);
        Node parent = this.currentNode.getParentNode();
        String className = "ignoredElement " + this.controller.getDecorateClassName() + " " + "decorate" + this.annotation.getId();
        if (parent.getNodeName().equalsIgnoreCase("span") && (parentClassName = ((SpanElement)parent.cast()).getClassName()).indexOf(this.controller.getDecorateClassName()) != -1) {
            className = parentClassName + " " + "decorate" + this.annotation.getId();
        }
        spanElement.setClassName(className);
        this.insertBefore(parent, this.currentNode.getNextSibling(), (Node)spanElement);
        return spanElement;
    }

    protected void decorateNode() {
        if (this.endNodeBeforeStartNode && (this.endNode.equals((Object)this.currentNode.getPreviousSibling()) || this.endNode.equals((Object)this.currentNode.getParentNode()))) {
            this.endNodeFound = true;
            this.endOffset = 0;
            return;
        }
        if (this.currentNode.getNodeType() != 3) {
            if (this.endNode.equals((Object)this.currentNode.getPreviousSibling())) {
                this.endNodeFound = true;
                this.endOffset = 0;
            } else if (this.endNode.equals((Object)this.currentNode)) {
                this.endNodeFound = true;
            }
            return;
        }
        Text text = (Text)this.currentNode;
        String data = text.getData();
        data = Utils.removeWhitespaces(data, this.currentNode);
        this.decorateText(data);
        this.currentNode.getParentNode().removeChild(this.currentNode);
    }

    protected SpanElement getSpanElement(Document document) {
        SpanElement spanElement = document.createSpanElement();
        DOM.sinkEvents((Element)((Element)spanElement.cast()), (int)48);
        DOM.setEventListener((Element)((Element)spanElement.cast()), (EventListener)AnnotationPopupEventListener.getAnnotationPopupEventListener(this.annotation, this.controller));
        return spanElement;
    }

    protected void insertBefore(Node parent, Node child, Node newChild) {
        if (child == null) {
            parent.appendChild(newChild);
        } else {
            parent.insertBefore(newChild, child);
        }
    }

    @Override
    public boolean doBreak() {
        return this.endNodeFound && this.endOffset <= 0;
    }
}

