/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationChangeListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationModel;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.CSSClassManager;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.ImageRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.NullRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Point;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.StringRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Utils;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Visitor;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPathUtil;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator.DecoratorVisitor;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator.DecoratorVisitorFactory;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator.ImageDecorator;

public class AnnotatedDocument
implements AnnotationChangeListener {
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private List<Annotation> decoratedAnnotations = new ArrayList<Annotation>();
    private static XPathUtil xPathUtil = new XPathUtil();
    private final ImageDecorator decorator;
    private AnnotationController controller;

    public AnnotatedDocument(AnnotationController controller) {
        this.controller = controller;
        this.decorator = new ImageDecorator(controller);
    }

    @Override
    public void onChange(AnnotationModel model, AnnotationChangeListener.ChangeEvent ce) {
        this.annotations = model.getAnnotations();
        Log.debug((String)("On change: annotations.empty? " + this.annotations.isEmpty()));
        if (this.annotations.isEmpty() || ce == AnnotationChangeListener.ChangeEvent.annotation) {
            return;
        }
        this.update();
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean forceDecorate) {
        Log.debug((String)("Update annotations - forceDecorate: " + forceDecorate));
        if (this.annotations == null) {
            return;
        }
        if (forceDecorate) {
            this.decoratedAnnotations.clear();
            this.removeAllAnnotatedAreas();
        }
        for (Annotation annotation : this.annotations) {
            if (this.decoratedAnnotations.contains(annotation)) continue;
            Log.debug((String)"Decorate annotation");
            this.decorate(annotation);
            this.decoratedAnnotations.add(annotation);
        }
        int selectedAnnotationIndex = this.getSelectedAnnotationIndex();
        if (selectedAnnotationIndex > -1) {
            this.updateSelectedAnnotation(selectedAnnotationIndex);
        }
        if (!this.isAnnotationsVisible()) {
            Log.debug((String)"Hide annotations!");
            this.hideAnnotations();
            this.controller.disablePopupListeners();
        }
    }

    public void preDecorateDocument() {
        Document document = Document.get();
        Log.debug((String)("preDecorateDocument -- isMultiImage? " + this.controller.isMultiImage()));
        AnnotatedDocument.preDecorateDocument(document);
    }

    private static void preDecorateDocument(Document document) {
        Log.debug((String)"Predecorate document !");
        NodeList elements = document.getElementsByTagName("img");
        for (int x = 0; x < elements.getLength(); ++x) {
            Element element = (Element)elements.getItem(x);
            DivElement divElement = document.createDivElement();
            divElement.getStyle().setProperty("position", "relative");
            divElement.setClassName("ignoredElement");
            String path = xPathUtil.getXPath((Node)element);
            path = XPathUtil.toIdableName(path);
            divElement.setId(path);
            Element nextSibling = element.getNextSiblingElement();
            Element parent = element.getParentElement();
            if (nextSibling == null) {
                parent.appendChild((Node)divElement);
            } else {
                parent.insertBefore((Node)divElement, (Node)nextSibling);
            }
            divElement.appendChild((Node)element);
        }
    }

    public void decorate(Annotation annotation) {
        XPointer xpointer = annotation.getXpointer();
        if (xpointer instanceof StringRangeXPointer) {
            this.decorateStringRange((StringRangeXPointer)xpointer, annotation);
        } else if (xpointer instanceof ImageRangeXPointer) {
            this.decorateImageRange((ImageRangeXPointer)xpointer, annotation);
        }
    }

    private void decorateImageRange(ImageRangeXPointer xpointer, Annotation annotation) {
        ImageElement img = xpointer.getImage(this.controller.isMultiImage());
        if (img == null) {
            return;
        }
        Point[] points = this.controller.filterAnnotation(xpointer.getTopLeft(), xpointer.getBottomRight());
        if (points == null) {
            return;
        }
        this.decorator.addAnnotatedArea(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), img, annotation, this.controller);
    }

    private void decorateStringRange(StringRangeXPointer xpointer, Annotation annotation) {
        DecoratorVisitor processor = DecoratorVisitorFactory.forAnnotation(annotation, this.controller);
        Visitor visitor = new Visitor(processor);
        visitor.process(xpointer.getOwnerDocument());
    }

    public void updateSelectedAnnotation(int index) {
        Annotation annotation = this.annotations.get(index);
        BodyElement bodyElement = Document.get().getBody();
        if (!(annotation.getXpointer() instanceof NullRangeXPointer)) {
            int[] absTopLeft;
            Element element;
            int x;
            NodeList spans = bodyElement.getElementsByTagName("span");
            NodeList as = bodyElement.getElementsByTagName("div");
            int scrollTop = Integer.MAX_VALUE;
            int scrollLeft = Integer.MAX_VALUE;
            for (x = 0; x < spans.getLength(); ++x) {
                element = (Element)spans.getItem(x);
                if (!this.processElement(annotation, element)) continue;
                absTopLeft = Utils.getAbsoluteTopLeft(element, Document.get());
                if (absTopLeft[0] < scrollTop) {
                    scrollTop = absTopLeft[0];
                }
                if (absTopLeft[1] >= scrollLeft) continue;
                scrollLeft = absTopLeft[1];
            }
            for (x = 0; x < as.getLength(); ++x) {
                element = (Element)as.getItem(x);
                if (!this.processElement(annotation, element)) continue;
                absTopLeft = Utils.getAbsoluteTopLeft(element, Document.get());
                if (absTopLeft[0] < scrollTop) {
                    scrollTop = absTopLeft[0];
                }
                if (absTopLeft[1] >= scrollLeft) continue;
                scrollLeft = absTopLeft[1];
            }
            bodyElement.setScrollTop(scrollTop == Integer.MAX_VALUE ? 0 : scrollTop);
            bodyElement.setScrollLeft(scrollLeft == Integer.MAX_VALUE ? 0 : scrollLeft);
        }
    }

    private boolean processElement(Annotation annotation, Element element) {
        CSSClassManager manager = new CSSClassManager(element);
        manager.removeClass("selectedAnnotation");
        if (manager.isClassPresent("decorate" + annotation.getId())) {
            manager.addClass("selectedAnnotation");
            return true;
        }
        return false;
    }

    private native int getSelectedAnnotationIndex();

    public void hideAnnotations() {
        CSSClassManager manager;
        Element element;
        int x;
        BodyElement bodyElement = Document.get().getBody();
        NodeList spans = bodyElement.getElementsByTagName("span");
        NodeList divs = bodyElement.getElementsByTagName("div");
        for (x = 0; x < spans.getLength(); ++x) {
            element = (Element)spans.getItem(x);
            manager = new CSSClassManager(element);
            if (!manager.isClassPresent("decorate")) continue;
            manager.removeClass("decorate");
            manager.addClass("decorateNot");
        }
        for (x = 0; x < divs.getLength(); ++x) {
            element = (Element)divs.getItem(x);
            manager = new CSSClassManager(element);
            if (!manager.isClassPresent("decorate")) continue;
            manager.removeClass("decorate");
            manager.addClass("decorateNot");
        }
        this.setAnnotationsShown(false);
    }

    private native void setAnnotationsShown(boolean var1);

    public void showAnnotations() {
        CSSClassManager manager;
        Element element;
        int x;
        BodyElement bodyElement = Document.get().getBody();
        NodeList spans = bodyElement.getElementsByTagName("span");
        NodeList divs = bodyElement.getElementsByTagName("div");
        for (x = 0; x < spans.getLength(); ++x) {
            element = (Element)spans.getItem(x);
            manager = new CSSClassManager(element);
            if (manager.isClassPresent("decorateNot")) {
                manager.removeClass("decorateNot");
                manager.addClass("decorate");
            }
            if (!manager.isClassPresent("selectedAnnotationNot")) continue;
            manager.removeClass("selectedAnnotationNot");
            manager.addClass("selectedAnnotation");
        }
        for (x = 0; x < divs.getLength(); ++x) {
            element = (Element)divs.getItem(x);
            manager = new CSSClassManager(element);
            if (manager.isClassPresent("decorateNot")) {
                manager.removeClass("decorateNot");
                manager.addClass("decorate");
            }
            if (!manager.isClassPresent("selectedAnnotationNot")) continue;
            manager.removeClass("selectedAnnotationNot");
            manager.addClass("selectedAnnotation");
        }
        this.setAnnotationsShown(true);
    }

    public native boolean isAnnotationsVisible();

    private void removeAllAnnotatedAreas() {
        String className = this.isAnnotationsVisible() ? "decorate" : "decorateNot";
        BodyElement bodyElement = Document.get().getBody();
        NodeList as = bodyElement.getElementsByTagName("div");
        this.removeAnchorAreas((NodeList<Element>)as, className);
        this.removeSpanAreas(className);
    }

    private void removeAnchorAreas(NodeList<Element> nodes, String className) {
        List<Element> elements = this.getElementsToRemove(nodes, className);
        for (Element element : elements) {
            element.getParentElement().removeChild((Node)element);
        }
    }

    private List<Element> getElementsToRemove(NodeList<Element> nodes, String className) {
        ArrayList<Element> elementsToRemove = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.getItem(i);
            CSSClassManager manager = new CSSClassManager(element);
            if (!manager.isClassPresent(className)) continue;
            elementsToRemove.add(element);
        }
        return elementsToRemove;
    }

    private void removeSpanAreas(String className) {
        NodeList spans = Document.get().getBody().getElementsByTagName("span");
        List<Element> elements = this.getElementsToRemove((NodeList<Element>)spans, className);
        while (!elements.isEmpty()) {
            Element element = elements.get(0);
            String elementHtml = element.getInnerHTML();
            Element parent = element.getParentElement();
            String parentHtml = parent.getInnerHTML();
            String escapedClassName = element.getClassName().replaceAll("([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])", "\\\\$1");
            String escapedElementHtml = elementHtml.replaceAll("([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])", "\\\\$1");
            parentHtml = parentHtml.replaceFirst("<(span|SPAN) class=(\")?" + escapedClassName + "(\")?.*>" + escapedElementHtml + "</(span|SPAN)>", elementHtml);
            parent.setInnerHTML(parentHtml);
            spans = Document.get().getBody().getElementsByTagName("span");
            elements = this.getElementsToRemove((NodeList<Element>)spans, className);
        }
    }

    public void decorateSelectedText(Annotation annotation) {
        DecoratorVisitor processor = DecoratorVisitorFactory.forSelectedText(annotation);
        Visitor visitor = new Visitor(processor);
        StringRangeXPointer xpointer = (StringRangeXPointer)annotation.getXpointer();
        visitor.process(xpointer.getOwnerDocument());
    }

    public void removeSelectedTextDecoration(Annotation annotation) {
        String className = "selectedText";
        this.removeSpanAreas(className);
    }
}

