/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.opensocial.GadgetContentRewriter;
import com.google.caja.opensocial.GadgetParser;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.GadgetRewriter;
import com.google.caja.opensocial.GadgetSpec;
import com.google.caja.opensocial.OpenSocialMessageType;
import com.google.caja.opensocial.UriCallback;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.Dom;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginEnvironment;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Pair;
import com.google.caja.util.ReadableReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGadgetRewriter
implements GadgetRewriter,
GadgetContentRewriter {
    private final MessageQueue mq;
    private final BuildInfo buildInfo;
    private CssSchema cssSchema;
    private HtmlSchema htmlSchema;
    private boolean debugMode;

    public DefaultGadgetRewriter(BuildInfo buildInfo, MessageQueue mq) {
        this.buildInfo = buildInfo;
        this.mq = mq;
    }

    public MessageQueue getMessageQueue() {
        return this.mq;
    }

    public void setCssSchema(CssSchema cssSchema) {
        this.cssSchema = cssSchema;
    }

    public void setHtmlSchema(HtmlSchema htmlSchema) {
        this.htmlSchema = htmlSchema;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public void rewrite(ExternalReference gadgetRef, UriCallback uriCallback, String view, Appendable output) throws UriCallbackException, GadgetRewriteException, IOException, ParseException {
        assert (gadgetRef.getUri().isAbsolute()) : gadgetRef.toString();
        this.rewrite(gadgetRef.getUri(), CharProducer.Factory.create(uriCallback.retrieve(gadgetRef, "text/xml"), new InputSource(gadgetRef.getUri())), uriCallback, view, output);
    }

    @Override
    public void rewrite(URI baseUri, CharProducer gadgetSpec, UriCallback uriCallback, String view, Appendable output) throws GadgetRewriteException, IOException, ParseException {
        GadgetParser parser = new GadgetParser();
        GadgetSpec spec = parser.parse(gadgetSpec, new InputSource(baseUri), view, this.mq);
        StringBuilder rewritten = new StringBuilder();
        this.rewriteContent(baseUri, spec.getContent(), uriCallback, (Appendable)rewritten);
        spec.setContent(rewritten.toString());
        parser.render(spec, output);
    }

    @Override
    public void rewriteContent(URI baseUri, Readable gadgetSpec, UriCallback uriCallback, Appendable output) throws GadgetRewriteException, IOException {
        CharProducer content = this.readReadable(gadgetSpec, new InputSource(baseUri));
        output.append(this.rewriteContent(baseUri, content, uriCallback));
    }

    public void rewriteContent(URI baseUri, CharProducer content, UriCallback uriCallback, Appendable output) throws GadgetRewriteException, IOException {
        output.append(this.rewriteContent(baseUri, content, uriCallback));
    }

    public Pair<Node, Element> rewriteContent(URI baseUri, Node htmlContent, UriCallback callback) throws GadgetRewriteException {
        PluginCompiler compiler = this.compileGadget(htmlContent, baseUri, callback);
        StringBuilder script = new StringBuilder();
        CajoledModule cajoled = compiler.getJavascript();
        if (cajoled != null) {
            JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(script));
            cajoled.render(this.createRenderContext(tc));
            tc.noMoreTokens();
        }
        Node dom = compiler.getStaticHtml();
        if (!compiler.getJobs().hasNoErrors()) {
            throw new GadgetRewriteException();
        }
        Document doc = dom.getOwnerDocument();
        Element scriptElement = doc.createElementNS(Namespaces.HTML_NAMESPACE_URI, "script");
        scriptElement.setAttributeNS(Namespaces.HTML_NAMESPACE_URI, "type", "text/javascript");
        scriptElement.appendChild(doc.createTextNode(script.toString()));
        return new Pair<Node, Element>(dom, scriptElement);
    }

    private String rewriteContent(URI baseUri, CharProducer content, UriCallback callback) throws GadgetRewriteException {
        DocumentFragment htmlContent;
        try {
            htmlContent = this.parseHtml(content, new InputSource(baseUri));
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.mq);
            throw new GadgetRewriteException(ex);
        }
        Pair<Node, Element> result = this.rewriteContent(baseUri, htmlContent, callback);
        Node dom = (Node)result.a;
        Element scriptElement = (Element)result.b;
        String html = dom != null ? Nodes.render(dom) : "";
        String script = scriptElement != null ? Nodes.render(scriptElement) : "";
        return html + script;
    }

    private DocumentFragment parseHtml(CharProducer htmlContent, InputSource src) throws GadgetRewriteException, ParseException {
        DomParser p = new DomParser(new HtmlLexer(htmlContent), src, this.mq);
        if (p.getTokenQueue().isEmpty()) {
            this.mq.addMessage((MessageTypeInt)OpenSocialMessageType.NO_CONTENT, src);
            throw new GadgetRewriteException("No content");
        }
        return p.parseFragment();
    }

    private PluginCompiler compileGadget(Node content, final URI baseUri, final UriCallback callback) throws GadgetRewriteException {
        PluginMeta meta = new PluginMeta(new PluginEnvironment(){

            public CharProducer loadExternalResource(ExternalReference ref, String mimeType) {
                Reader content;
                ExternalReference absRef = new ExternalReference(baseUri.resolve(ref.getUri()), ref.getReferencePosition());
                try {
                    content = callback.retrieve(absRef, mimeType);
                    if (content == null) {
                        return null;
                    }
                }
                catch (UriCallbackException ex) {
                    return null;
                }
                try {
                    return CharProducer.Factory.create(content, new InputSource(absRef.getUri()));
                }
                catch (IOException ex) {
                    DefaultGadgetRewriter.this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.getMessage()));
                    return null;
                }
            }

            public String rewriteUri(ExternalReference ref, String mimeType) {
                ExternalReference absRef = new ExternalReference(baseUri.resolve(ref.getUri()), ref.getReferencePosition());
                try {
                    URI uri = callback.rewrite(absRef, mimeType);
                    if (uri == null) {
                        return null;
                    }
                    return uri.toString();
                }
                catch (UriCallbackException ex) {
                    return null;
                }
            }
        });
        meta.setDebugMode(this.debugMode);
        PluginCompiler compiler = this.createPluginCompiler(meta, this.mq);
        compiler.addInput(AncestorChain.instance(new Dom(content)));
        if (!compiler.run()) {
            throw new GadgetRewriteException("Gadget has compile errors");
        }
        return compiler;
    }

    private CharProducer readReadable(Readable input, InputSource src) throws IOException {
        return CharProducer.Factory.create((Reader)new ReadableReader(input), src);
    }

    protected RenderContext createRenderContext(TokenConsumer tc) {
        return new RenderContext(tc).withAsciiOnly(true).withEmbeddable(true);
    }

    protected PluginCompiler createPluginCompiler(PluginMeta meta, MessageQueue mq) {
        PluginCompiler compiler = new PluginCompiler(this.buildInfo, meta, mq);
        if (this.cssSchema != null) {
            compiler.setCssSchema(this.cssSchema);
        }
        if (this.htmlSchema != null) {
            compiler.setHtmlSchema(this.htmlSchema);
        }
        return compiler;
    }
}

