/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import org.nuxeo.ecm.platform.annotations.repository.descriptor.DocumentAnnotabilityDescriptor;
import org.nuxeo.ecm.platform.annotations.repository.descriptor.DocumentEventListenerDescriptor;
import org.nuxeo.ecm.platform.annotations.repository.descriptor.EventIdDescriptor;
import org.nuxeo.ecm.platform.annotations.repository.descriptor.GraphManagerEventListenerDescriptor;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsFulltextInjector;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryConfigurationService;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryConfigurationServiceImpl;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryConstants;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryService;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryServiceImpl;
import org.nuxeo.ecm.platform.annotations.repository.service.DocumentAnnotability;
import org.nuxeo.ecm.platform.annotations.repository.service.GraphManagerEventListener;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AnnotationsRepositoryComponent
extends DefaultComponent {
    public static AnnotationsRepositoryComponent instance;
    protected AnnotationsRepositoryServiceImpl annotationsRepositoryService;
    protected AnnotationsRepositoryConfigurationServiceImpl confImpl;
    protected AnnotationsFulltextInjector injector;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        AnnotationsRepositoryConstants.ExtensionPoint point = Enum.valueOf(AnnotationsRepositoryConstants.ExtensionPoint.class, extensionPoint);
        switch (point) {
            case documentAnnotability: {
                DocumentAnnotability annotability = ((DocumentAnnotabilityDescriptor)contribution).getKlass().newInstance();
                this.annotationsRepositoryService.setDocumentAnnotability(annotability);
                break;
            }
            case documentEventListener: {
                AnnotatedDocumentEventListener listener = ((DocumentEventListenerDescriptor)contribution).getListener().newInstance();
                String listenerName = ((DocumentEventListenerDescriptor)contribution).getName();
                this.confImpl.addEventListener(listenerName, listener);
                break;
            }
            case jcrLifecycleEventId: {
                String eventId = ((EventIdDescriptor)contribution).getEventId();
                this.confImpl.addEventId(eventId);
                break;
            }
            case graphManagerEventListener: {
                GraphManagerEventListener graphListener = ((GraphManagerEventListenerDescriptor)contribution).getKlass().newInstance();
                this.confImpl.setGraphManagerEventListener(graphListener);
            }
        }
    }

    public void activate(ComponentContext context) throws Exception {
        instance = this;
        this.annotationsRepositoryService = new AnnotationsRepositoryServiceImpl();
        this.confImpl = new AnnotationsRepositoryConfigurationServiceImpl();
        this.injector = new AnnotationsFulltextInjector();
    }

    public void deactivate(ComponentContext context) throws Exception {
        instance = null;
        this.annotationsRepositoryService.clear();
        this.annotationsRepositoryService = null;
        this.injector = null;
    }

    public AnnotationsFulltextInjector getFulltextInjector() {
        return this.injector;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (AnnotationsRepositoryService.class.isAssignableFrom(adapter)) {
            return (T)this.annotationsRepositoryService;
        }
        if (AnnotationsRepositoryConfigurationService.class.isAssignableFrom(adapter)) {
            return (T)this.confImpl;
        }
        return null;
    }
}

