/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.listener;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsFulltextInjector;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryComponent;

public class AnnotationFulltextEventListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        AnnotationsFulltextInjector injector = AnnotationsRepositoryComponent.instance.getFulltextInjector();
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext context = (DocumentEventContext)event.getContext();
        CoreSession session = context.getCoreSession();
        DocumentModel doc = context.getSourceDocument();
        if (doc == null) {
            return;
        }
        if (!doc.hasFacet("HasRelatedText")) {
            return;
        }
        String annotationId = (String)((Object)context.getProperty("annotationId"));
        String annotationBody = (String)((Object)context.getProperty("annotationBody"));
        if ("annotationCreated".equals(event.getName())) {
            injector.setAnnotationText(doc, annotationId, annotationBody);
            session.saveDocument(doc);
        } else if ("annotationDeleted".equals(event.getName())) {
            if (injector.removeAnnotationText(doc, annotationId)) {
                session.saveDocument(doc);
            }
        } else if ("annotationUpdated".equals(event.getName())) {
            injector.removeAnnotationText(doc, annotationId);
            injector.setAnnotationText(doc, annotationId, annotationBody);
            session.saveDocument(doc);
        } else if ("documentCheckedIn".equals(event.getName())) {
            DocumentRef versionRef = (DocumentRef)context.getProperty("checkedInVersionRef");
            DocumentModel version = session.getDocument(versionRef);
            if (injector.removeAnnotationText(version, null)) {
                session.saveDocument(version);
            }
        } else {
            return;
        }
    }
}

