/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client;

import org.nuxeo.gwt.habyt.upload.client.core.UploadForm;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public interface Uploader {

    public static final String UPLOADED_FILE_ID_PREFIX = "gwt_";

    public static final int DEFAULT_TIMEOUT = 1500;

    /**
     * Get the form upload target URL.
     * 
     * @return
     */
    public String getUploadUrl(FileRef ref);

    /**
     * Get the URL of the file remove server service
     * 
     * @param id
     * @return
     */
    String getRemoveUrl(String id);

    /**
     * Get the URL of the view file server service
     * 
     * @param id
     * @return
     */
    String getViewUrl(String id);

    /**
     * Get the URL of the progress notification server service
     * 
     * @param id
     * @return
     */
    String getProgressUrl(String id);

    /**
     * Get the registered file widget provider if any otherwise returns null
     * 
     * @return the file widget provider or null if none.
     */
    FileWidgetProvider getFileWidgetProvider();

    /**
     * Add a listener on file events
     * 
     * @param handler
     * @return
     */
    HandlerRegistration addFileEventHandler(FileEventHandler handler);

    /**
     * File upload started
     * 
     * @param form
     */
    public boolean onSubmit(UploadForm form);

    /**
     * File submit done. Called by {@link UploadForm}
     * 
     * @param ref
     */
    public void onSubmitDone(UploadForm form);

    /**
     * File submit error. Called by {@link UploadForm}
     * 
     * @param ref
     */
    public void onSubmitError(UploadForm form);

    /**
     * Test whether there is any active upload.
     * 
     * @return
     */
    public boolean hasActiveUploads();

    /**
     * Check the upload progress for the given file.
     * 
     * @param ref
     */
    public void checkProgress(FileRef ref);

    /**
     * Add an upload request to the queue
     * 
     * @param form
     */
    public boolean addUploadRequest(UploadForm form);

    /**
     * Remove for the given file (and cancel the submission if upload in
     * progress)
     * 
     * @param ref
     */
    public void removeFile(FileRef ref);

    /**
     * Set the type of upload - either single or multi upload. The default is
     * multi upload.
     * 
     * @param isMultiUpload
     */
    public void setMultiUpload(boolean isMultiUpload);

    /**
     * Tests whether this uploader may upload multiple files.
     * 
     * @return
     */
    public boolean isMultiUpload();

    /**
     * Get the widget used by this uploader.
     * 
     * @return
     */
    public Widget getWidget();

}
