/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.utils;

import java.util.ArrayList;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageActionPipe;
import org.nuxeo.ecm.platform.mail.action.Visitor;
import org.nuxeo.ecm.platform.mail.listener.MailEventListener;
import org.nuxeo.ecm.platform.mail.service.MailService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public final class MailCoreHelper {
    private static final Log log = LogFactory.getLog(MailEventListener.class);
    public static final String PIPE_NAME = "nxmail";
    public static final String INBOX = "INBOX";
    public static final String DELETED_LIFECYCLE_STATE = "deleted";
    public static final long EMAILS_LIMIT_DEFAULT = 100L;
    private static MailService mailService;
    private static MimetypeRegistry mimeService;

    private MailCoreHelper() {
    }

    private static MailService getMailService() {
        if (mailService == null) {
            try {
                mailService = (MailService)Framework.getService(MailService.class);
            }
            catch (Exception e) {
                log.error((Object)"Exception in get mail service");
            }
        }
        return mailService;
    }

    private static MimetypeRegistry getMimeService() {
        if (mimeService == null) {
            try {
                mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            }
            catch (Exception e) {
                log.error((Object)"Exception in get mime service");
            }
        }
        return mimeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMail(DocumentModel currentMailFolder, CoreSession coreSession) throws Exception {
        String email = (String)((Object)currentMailFolder.getPropertyValue("prot:email"));
        String password = (String)((Object)currentMailFolder.getPropertyValue("prot:password"));
        if (!StringUtils.isEmpty((String)email) && !StringUtils.isEmpty((String)password)) {
            mailService = MailCoreHelper.getMailService();
            MessageActionPipe pipe = mailService.getPipe(PIPE_NAME);
            Visitor visitor = new Visitor(pipe);
            Thread.currentThread().setContextClassLoader(Framework.class.getClassLoader());
            ExecutionContext initialExecutionContext = new ExecutionContext();
            initialExecutionContext.put("mimetypeService", MailCoreHelper.getMimeService());
            initialExecutionContext.put("parentPath", currentMailFolder.getPathAsString());
            initialExecutionContext.put("sessionId", coreSession.getSessionId());
            initialExecutionContext.put("leaveOnServer", Boolean.TRUE);
            Folder rootFolder = null;
            try {
                String protocolType = (String)((Object)currentMailFolder.getPropertyValue("prot:protocol_type"));
                initialExecutionContext.put("protocolType", protocolType);
                String host = (String)((Object)currentMailFolder.getPropertyValue("prot:host"));
                String port = (String)((Object)currentMailFolder.getPropertyValue("prot:port"));
                Boolean socketFactoryFallback = (Boolean)currentMailFolder.getPropertyValue("prot:socket_factory_fallback");
                String socketFactoryPort = (String)((Object)currentMailFolder.getPropertyValue("prot:socket_factory_port"));
                Boolean starttlsEnable = (Boolean)currentMailFolder.getPropertyValue("prot:starttls_enable");
                String sslProtocols = (String)((Object)currentMailFolder.getPropertyValue("prot:ssl_protocols"));
                Long emailsLimit = (Long)currentMailFolder.getPropertyValue("prot:emails_limit");
                long emailsLimitLongValue = emailsLimit == null ? 100L : emailsLimit;
                Properties properties = new Properties();
                properties.put("mail.store.protocol", protocolType);
                if ("imap".equals(protocolType)) {
                    properties.put("mail.imap.host", host);
                    properties.put("mail.imap.port", port);
                    properties.put("mail.imap.starttls.enable", starttlsEnable.toString());
                    properties.put("mail.imap.debug", "true");
                } else if ("imaps".equals(protocolType)) {
                    properties.put("mail.imaps.host", host);
                    properties.put("mail.imaps.port", port);
                    properties.put("mail.imaps.starttls.enable", starttlsEnable.toString());
                    properties.put("mail.imaps.ssl.protocols", sslProtocols);
                    properties.put("mail.imaps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                    properties.put("mail.imaps.socketFactory.fallback", socketFactoryFallback.toString());
                    properties.put("mail.imaps.socketFactory.port", socketFactoryPort);
                } else if ("pop3s".equals(protocolType)) {
                    properties.put("mail.pop3s.host", host);
                    properties.put("mail.pop3s.port", port);
                    properties.put("mail.pop3s.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                    properties.put("mail.pop3s.socketFactory.fallback", socketFactoryFallback.toString());
                    properties.put("mail.pop3s.socketFactory.port", socketFactoryPort);
                    properties.put("mail.pop3s.ssl.protocols", sslProtocols);
                } else {
                    properties.put("mail.pop3.host", host);
                    properties.put("mail.pop3.port", port);
                }
                properties.put("user", email);
                properties.put("password", password);
                Session session = Session.getInstance((Properties)properties);
                Store store = session.getStore();
                store.connect(email, password);
                String folderName = INBOX;
                rootFolder = store.getFolder(folderName);
                rootFolder.open(2);
                Message[] allMessages = rootFolder.getMessages();
                log.debug((Object)("nbr of messages in folder:" + allMessages.length));
                FetchProfile fetchProfile = new FetchProfile();
                fetchProfile.add(FetchProfile.Item.FLAGS);
                rootFolder.fetch(allMessages, fetchProfile);
                ArrayList<Message> unreadMessagesList = new ArrayList<Message>();
                for (Message message : allMessages) {
                    Flags flags = message.getFlags();
                    int unreadMessagesListSize = unreadMessagesList.size();
                    if (flags == null || flags.contains(Flags.Flag.SEEN) || (long)unreadMessagesListSize >= emailsLimitLongValue) continue;
                    unreadMessagesList.add(message);
                    if ((long)unreadMessagesListSize == emailsLimitLongValue - 1L) break;
                }
                visitor.visit(unreadMessagesList.toArray(new Message[unreadMessagesList.size()]), initialExecutionContext);
            }
            finally {
                if (rootFolder != null && rootFolder.isOpen()) {
                    rootFolder.close(true);
                }
            }
        }
    }
}

