/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageAction;

public class TransformMessageAction
implements MessageAction {
    private static final Log log = LogFactory.getLog(TransformMessageAction.class);
    protected final Map<String, Map<String, Object>> schemas = new HashMap<String, Map<String, Object>>();
    protected final Map<String, Object> mailSchema = new HashMap<String, Object>();
    protected final Map<String, Object> dcSchema = new HashMap<String, Object>();
    protected final Map<String, Object> filesSchema = new HashMap<String, Object>();
    protected final List<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
    protected StringBuilder text = new StringBuilder();
    private final HashMap<String, List<Part>> messageBodyParts = new HashMap();

    public TransformMessageAction() {
        this.messageBodyParts.put("text", new ArrayList());
        this.messageBodyParts.put("html", new ArrayList());
        this.schemas.put("mail", this.mailSchema);
        this.schemas.put("dublincore", this.dcSchema);
        this.filesSchema.put("files", this.files);
        this.schemas.put("files", this.filesSchema);
    }

    @Override
    public boolean execute(ExecutionContext context) throws Exception {
        Message message = context.getMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Transforming message" + message.getSubject()));
        }
        if (message.getFrom() != null && message.getFrom().length != 0) {
            ArrayList<String> contributors = new ArrayList<String>();
            for (Address ad : message.getFrom()) {
                contributors.add(TransformMessageAction.safelyDecodeText(ad.toString()));
            }
            this.dcSchema.put("contributors", contributors);
            this.dcSchema.put("creator", contributors.get(0));
            this.dcSchema.put("created", message.getReceivedDate());
        }
        if (message.getAllRecipients() != null && message.getAllRecipients().length != 0) {
            ArrayList<String> recipients = new ArrayList<String>();
            for (Address address : message.getAllRecipients()) {
                recipients.add(TransformMessageAction.safelyDecodeText(address.toString()));
            }
            this.mailSchema.put("recipients", recipients);
        }
        if (message instanceof MimeMessage) {
            this.processMimeMessage((MimeMessage)message);
        }
        this.mailSchema.put("text", this.text.toString());
        this.dcSchema.put("title", message.getSubject());
        context.put("transformed", this.schemas);
        return true;
    }

    private void processMimeMessage(MimeMessage message) throws MessagingException, IOException {
        Object object = message.getContent();
        if (object instanceof String) {
            this.addToTextMessage(message.getContent().toString(), true);
        } else if (object instanceof MimeMultipart) {
            this.processMultipartMessage((MimeMultipart)object);
            this.processSavedTextMessageBody();
        }
    }

    private void processMultipartMessage(MimeMultipart parts) throws MessagingException, IOException {
        log.debug((Object)"processing multipart message.");
        for (int i = 0; i < parts.getCount(); ++i) {
            BodyPart part = parts.getBodyPart(i);
            if (part.getDataHandler().getContent() instanceof MimeMultipart) {
                log.debug((Object)"** found embedded multipart message");
                this.processMultipartMessage((MimeMultipart)part.getDataHandler().getContent());
                continue;
            }
            log.debug((Object)("processing single part message: " + part.getClass()));
            this.processSingleMessagePart((Part)part);
        }
    }

    private void processSingleMessagePart(Part part) throws MessagingException, IOException {
        String partContentType = part.getContentType();
        String partFileName = TransformMessageAction.getFileName(part);
        if (partFileName != null) {
            log.debug((Object)("Add named attachment: " + partFileName));
            this.setFile(partFileName, part.getInputStream());
            return;
        }
        if (!TransformMessageAction.contentTypeIsReadableText(partContentType)) {
            log.debug((Object)"Add unnamed binary attachment.");
            this.setFile(null, part.getInputStream());
            return;
        }
        if (TransformMessageAction.contentTypeIsPlainText(partContentType)) {
            log.debug((Object)"found plain text unnamed attachment [save for later processing]");
            this.messageBodyParts.get("text").add(part);
            return;
        }
        log.debug((Object)"found html unnamed attachment [save for later processing]");
        this.messageBodyParts.get("html").add(part);
    }

    private void processSavedTextMessageBody() throws MessagingException, IOException {
        if (this.messageBodyParts.get("text").isEmpty()) {
            log.debug((Object)"entering case 2: no plain text found -> html is the body of the message.");
            this.addPartsToTextMessage(this.messageBodyParts.get("html"));
        } else {
            log.debug((Object)"entering case 1: text is saved as message body and html as attachment.");
            this.addPartsToTextMessage(this.messageBodyParts.get("text"));
            this.addPartsAsAttachements(this.messageBodyParts.get("html"));
        }
    }

    private void addPartsToTextMessage(List<Part> someMessageParts) throws MessagingException, IOException {
        for (Part part : someMessageParts) {
            this.addToTextMessage(part.getContent().toString(), TransformMessageAction.contentTypeIsPlainText(part.getContentType()));
        }
    }

    private void addPartsAsAttachements(List<Part> someMessageParts) throws MessagingException, IOException {
        for (Part part : someMessageParts) {
            this.setFile(TransformMessageAction.getFileName(part), part.getInputStream());
        }
    }

    private static boolean contentTypeIsReadableText(String contentType) {
        boolean isText = TransformMessageAction.contentTypeIsPlainText(contentType);
        boolean isHTML = TransformMessageAction.contentTypeIsHtml(contentType);
        return isText || isHTML;
    }

    private static boolean contentTypeIsHtml(String contentType) {
        contentType = contentType.trim().toLowerCase();
        return contentType.startsWith("text/html");
    }

    private static boolean contentTypeIsPlainText(String contentType) {
        contentType = contentType.trim().toLowerCase();
        return contentType.startsWith("text/plain");
    }

    private static String getFileName(Part mailPart) throws MessagingException {
        String sysPropertyVal = System.getProperty("mail.mime.decodefilename");
        boolean decodeFileName = sysPropertyVal != null && !sysPropertyVal.equalsIgnoreCase("false");
        String encodedFilename = mailPart.getFileName();
        if (!decodeFileName || encodedFilename == null) {
            return encodedFilename;
        }
        try {
            return MimeUtility.decodeText((String)encodedFilename);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MessagingException("Can't decode attachment filename.", (Exception)ex);
        }
    }

    private static String safelyDecodeText(String textToDecode) {
        try {
            return MimeUtility.decodeText((String)textToDecode);
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Can't decode text. Use undecoded!", (Throwable)ex);
            return textToDecode;
        }
    }

    private void setFile(String fileName, InputStream inputStream) throws IOException {
        log.debug((Object)("* adding attachment: " + fileName));
        HashMap<String, Object> map = new HashMap<String, Object>();
        FileBlob fileBlob = new FileBlob(inputStream);
        map.put("file", fileBlob);
        map.put("filename", fileName);
        this.files.add(map);
    }

    private void addToTextMessage(String message, boolean isPlainText) {
        log.debug((Object)("* adding text to message body: " + message));
        this.text.append(message);
    }

    @Override
    public void reset(ExecutionContext context) throws Exception {
        this.mailSchema.clear();
        this.dcSchema.clear();
        this.files.clear();
        this.text = new StringBuilder();
        this.messageBodyParts.get("text").clear();
        this.messageBodyParts.get("html").clear();
    }
}

