/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.templates.IHTML;
import com.google.caja.plugin.templates.IhtmlL10NContext;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.LocalizedHtml;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Localizer {
    private final MessageQueue mq;
    private static final String XML_NS = Namespaces.XML_NAMESPACE_URI;

    public Localizer(MessageQueue mq) {
        this.mq = mq;
    }

    public void localize(Element root, IhtmlL10NContext cx) {
        Document doc = root.getOwnerDocument();
        for (Element message : Localizer.snapshot(Localizer.allMessages(root))) {
            DocumentFragment substitutedMessage;
            String name = IHTML.getName(message).getValue();
            final Map<String, Placeholder> placeholders = this.byName(this.extractPlaceholders(message));
            LocalizedHtml substitution = cx.getMessageByName(name);
            if (substitution == null) {
                this.notifyUntranslatedMessage(message, cx.getLocale());
                substitution = this.messageToLocalizedHtml(message);
            }
            try {
                substitutedMessage = substitution.substitute(doc, new LocalizedHtml.PlaceholderHandler(){

                    @Override
                    public Iterator<Token<HtmlTokenType>> substitutePlaceholder(String placeholderName, FilePosition placeholderLoc) {
                        Placeholder ph = (Placeholder)placeholders.get(placeholderName);
                        if (ph == null) {
                            Localizer.this.notifyMissingPlaceholder(placeholderLoc);
                            return Collections.emptyList().iterator();
                        }
                        return Localizer.tokensFromNode(ph.start).iterator();
                    }
                });
            }
            catch (ParseException ex) {
                this.notifyMalformedMessage(message, name);
                ex.toMessageQueue(this.mq);
                substitutedMessage = doc.createDocumentFragment();
            }
            for (Node node : Nodes.childrenOf(substitutedMessage)) {
                message.getParentNode().insertBefore(node, message);
            }
            message.getParentNode().removeChild(message);
        }
    }

    private List<Placeholder> extractPlaceholders(Element message) {
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>();
        Element ph = null;
        for (Element element : IHTML.getPlaceholders(message)) {
            if (ph != null) {
                Element eph = element;
                assert (IHTML.isPh(ph));
                assert (IHTML.isEph(eph));
                placeholders.add(new Placeholder(ph));
                ph = null;
                continue;
            }
            ph = element;
        }
        assert (ph == null);
        return placeholders;
    }

    private Map<String, Placeholder> byName(List<Placeholder> phs) {
        LinkedHashMap<String, Placeholder> byName = new LinkedHashMap<String, Placeholder>();
        for (Placeholder ph : phs) {
            String name = IHTML.getName(ph.start).getValue();
            if (byName.containsKey(name)) {
                this.notifyDupePlaceholder(ph, (Placeholder)byName.get(name));
            }
            byName.put(name, ph);
        }
        return byName;
    }

    public IhtmlL10NContext extractMessages(Element ihtmlRoot) {
        Locale locale = ihtmlRoot.hasAttributeNS(XML_NS, "lang") ? new Locale(ihtmlRoot.getAttributeNS(XML_NS, "lang").replace('-', '_')) : Locale.ENGLISH;
        HashMap<String, Element> messageEls = new HashMap<String, Element>();
        LinkedHashMap<String, LocalizedHtml> messages = new LinkedHashMap<String, LocalizedHtml>();
        for (Element message : Localizer.allMessages(ihtmlRoot)) {
            LocalizedHtml extracted = this.messageToLocalizedHtml(message);
            if (extracted == null) continue;
            LocalizedHtml orig = (LocalizedHtml)messages.get(extracted.getName());
            if (orig != null) {
                if (orig.getSerializedForm().equals(extracted.getSerializedForm())) continue;
                this.notifyDupeMessage(message, (Element)messageEls.get(extracted.getName()));
                continue;
            }
            messages.put(extracted.getName(), extracted);
            messageEls.put(extracted.getName(), message);
        }
        return new IhtmlL10NContext(locale, messages);
    }

    private LocalizedHtml messageToLocalizedHtml(Element message) {
        message = (Element)message.cloneNode(true);
        String name = IHTML.getName(message).getValue();
        StringBuilder filteredXhtml = new StringBuilder();
        if (message.getFirstChild() != null) {
            StringBuilder xhtml = new StringBuilder();
            RenderContext rc = new RenderContext(new Concatenator(xhtml)).withAsXml(true).withAsciiOnly(true);
            for (Node node : Nodes.childrenOf(message)) {
                Nodes.render(node, rc);
            }
            rc.getOut().noMoreTokens();
            HtmlLexer lexer = new HtmlLexer(CharProducer.Factory.fromString((CharSequence)xhtml.toString(), Nodes.getFilePositionFor(message.getFirstChild())));
            lexer.setTreatedAsXml(true);
            boolean bl = false;
            try {
                while (lexer.hasNext()) {
                    int n;
                    Token tt = lexer.next();
                    boolean emit = n < 2;
                    switch ((HtmlTokenType)tt.type) {
                        case TAGBEGIN: {
                            if (n == 0 && "<ihtml:ph".equals(tt.text)) {
                                n = 1;
                                break;
                            }
                            if (n != 2 || !"<ihtml:eph".equals(tt.text)) break;
                            n = 3;
                            break;
                        }
                        case TAGEND: {
                            if (n == 1) {
                                n = 2;
                            } else if (n == 3) {
                                n = 0;
                            }
                            if (!emit || !"/>".equals(tt.text)) break;
                            filteredXhtml.append(' ');
                            break;
                        }
                        case ATTRNAME: {
                            if (!emit) break;
                            filteredXhtml.append(' ');
                            break;
                        }
                        case ATTRVALUE: {
                            if (!emit) break;
                            filteredXhtml.append('=');
                            break;
                        }
                    }
                    if (!emit) continue;
                    filteredXhtml.append(tt.text);
                }
            }
            catch (ParseException ex) {
                throw new RuntimeException("IOException reading from String");
            }
        }
        return new LocalizedHtml(name, filteredXhtml.toString());
    }

    private static Iterable<Element> allMessages(Element root) {
        return Nodes.nodeListIterable(root.getElementsByTagNameNS(IHTML.NAMESPACE, "message"), Element.class);
    }

    private static <T> List<T> snapshot(Iterable<T> it) {
        ArrayList<T> snapshot = new ArrayList<T>();
        for (T el : it) {
            snapshot.add(el);
        }
        return snapshot;
    }

    private void notifyUntranslatedMessage(Element message, Locale locale) {
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.UNTRANSLATED_MESSAGE, Nodes.getFilePositionFor(message), MessagePart.Factory.valueOf(IHTML.getName(message).getValue()), MessagePart.Factory.valueOf(locale.toString()));
    }

    private void notifyMissingPlaceholder(FilePosition phLoc) {
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MISSING_PLACEHOLDER, phLoc);
    }

    private void notifyMalformedMessage(Element message, String name) {
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MALFORMED_MESSAGE, Nodes.getFilePositionFor(message), MessagePart.Factory.valueOf(name));
    }

    private void notifyDupeMessage(Element a, Element b) {
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.DUPLICATE_MESSAGE, Nodes.getFilePositionFor(a), MessagePart.Factory.valueOf(IHTML.getName(a).getValue()), Nodes.getFilePositionFor(b));
    }

    private void notifyDupePlaceholder(Placeholder ph, Placeholder orig) {
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.DUPLICATE_PLACEHOLDER, Nodes.getFilePositionFor(ph.start), MessagePart.Factory.valueOf(IHTML.getName(ph.start).getValue()), Nodes.getFilePositionFor(orig.start));
    }

    public static Iterable<Token<HtmlTokenType>> tokensFromNode(Node n) {
        ArrayList<Token<HtmlTokenType>> toks = new ArrayList<Token<HtmlTokenType>>();
        Node ancestor = n;
        block0: while (true) {
            Node sib = ancestor;
            while ((sib = sib.getNextSibling()) != null) {
                if (Localizer.emitTokens(sib, toks)) continue;
                break block0;
            }
            if ((ancestor = ancestor.getParentNode()) == null) break;
            Localizer.emitEndOf(ancestor, toks);
        }
        return toks;
    }

    private static boolean emitTokens(Node n, List<Token<HtmlTokenType>> out) {
        FilePosition pos = Nodes.getFilePositionFor(n);
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                out.add(Token.instance(Nodes.encode(n.getNodeValue()), HtmlTokenType.TEXT, pos));
                break;
            }
            case 1: {
                if (IHTML.isEph(n)) {
                    return false;
                }
                Element e = (Element)n;
                FilePosition spos = FilePosition.startOf(pos);
                out.add(Token.instance("<" + Localizer.tagName(e), HtmlTokenType.TAGBEGIN, spos));
                FilePosition cpos = spos;
                for (Attr attr : Nodes.attributesOf(e)) {
                    Localizer.emitTokens(attr, out);
                    cpos = Nodes.getFilePositionForValue(attr);
                }
                cpos = FilePosition.endOf(cpos);
                if (n.getFirstChild() == null) {
                    out.add(Token.instance("/>", HtmlTokenType.TAGEND, cpos));
                    break;
                }
                out.add(Token.instance(">", HtmlTokenType.TAGEND, cpos));
                for (Node node : Nodes.childrenOf(n)) {
                    if (Localizer.emitTokens(node, out)) continue;
                    return false;
                }
                Localizer.emitEndOf(e, out);
                break;
            }
            case 2: {
                Attr a = (Attr)n;
                out.add(Token.instance(a.getName(), HtmlTokenType.ATTRNAME, pos));
                out.add(Token.instance('\"' + Nodes.encode(a.getValue()) + '\"', HtmlTokenType.ATTRVALUE, Nodes.getFilePositionForValue(a)));
                break;
            }
        }
        return true;
    }

    private static void emitEndOf(Node n, List<Token<HtmlTokenType>> out) {
        if (n instanceof Element) {
            Element e = (Element)n;
            FilePosition epos = FilePosition.endOf(Nodes.getFilePositionFor(e));
            out.add(Token.instance("</" + Localizer.tagName(e), HtmlTokenType.TAGBEGIN, epos));
            out.add(Token.instance(">", HtmlTokenType.TAGEND, epos));
        }
    }

    private static String tagName(Element e) {
        Namespaces ns = Namespaces.COMMON.forUri(e.getNamespaceURI());
        String prefix = ns != null ? ns.prefix : "";
        String localName = e.getLocalName();
        return "".equals(prefix) ? localName : prefix + ":" + localName;
    }

    private static class Placeholder {
        final Element start;

        Placeholder(Element ph) {
            this.start = ph;
        }
    }
}

