/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import com.google.api.client.auth.oauth2.Credential;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class NuxeoOAuth2Token {
    public static final String SCHEMA = "oauth2Token";
    protected Long id;
    protected String serviceName;
    protected String nuxeoLogin;
    protected String accessToken;
    private String refreshToken;
    private Long expirationTimeMilliseconds;

    public NuxeoOAuth2Token(String accessToken, String refreshToken, Long expirationTimeMilliseconds) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expirationTimeMilliseconds = expirationTimeMilliseconds;
    }

    public NuxeoOAuth2Token(Credential credential) {
        this(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds());
    }

    public NuxeoOAuth2Token(DocumentModel entry) throws ClientException {
        this.id = (Long)entry.getProperty(SCHEMA, "id");
        this.accessToken = (String)entry.getProperty(SCHEMA, "accessToken");
        this.refreshToken = (String)entry.getProperty(SCHEMA, "refreshToken");
        this.expirationTimeMilliseconds = (Long)entry.getProperty(SCHEMA, "expirationTimeMilliseconds");
        this.serviceName = (String)entry.getProperty(SCHEMA, "serviceName");
        this.nuxeoLogin = (String)entry.getProperty(SCHEMA, "nuxeoLogin");
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceName", this.serviceName);
        map.put("nuxeoLogin", this.nuxeoLogin);
        map.put("accessToken", this.accessToken);
        map.put("refreshToken", this.refreshToken);
        map.put("expirationTimeMilliseconds", this.expirationTimeMilliseconds);
        return map;
    }

    public void updateEntry(DocumentModel entry) throws ClientException {
        entry.setProperty(SCHEMA, "serviceName", (Object)this.serviceName);
        entry.setProperty(SCHEMA, "nuxeoLogin", (Object)this.nuxeoLogin);
        entry.setProperty(SCHEMA, "accessToken", (Object)this.accessToken);
        entry.setProperty(SCHEMA, "refreshToken", (Object)this.refreshToken);
        entry.setProperty(SCHEMA, "expirationTimeMilliseconds", (Object)this.expirationTimeMilliseconds);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setNuxeoLogin(String userId) {
        this.nuxeoLogin = userId;
    }

    public String getNuxeoLogin() {
        return this.nuxeoLogin;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Long getExpirationTimeMilliseconds() {
        return this.expirationTimeMilliseconds;
    }

    public void setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        this.expirationTimeMilliseconds = expirationTimeMilliseconds;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

