/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.plugin.PluginEnvironment;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManager {
    private final PluginEnvironment pluginEnv;
    private final BuildInfo buildInfo;
    private final MessageQueue mq;
    private final boolean isValija;
    private final Map<String, Integer> moduleNameMap = new HashMap<String, Integer>();
    private final Map<Integer, CajoledModule> moduleIndexMap = new HashMap<Integer, CajoledModule>();
    private int moduleCounter = 0;

    public ModuleManager(BuildInfo buildInfo, PluginEnvironment pluginEnv, MessageQueue mq, boolean isValija) {
        this.buildInfo = buildInfo;
        this.pluginEnv = pluginEnv;
        this.mq = mq;
        this.isValija = isValija;
    }

    public Map<Integer, CajoledModule> getModuleIndexMap() {
        return this.moduleIndexMap;
    }

    public void appendUncajoledModule(UncajoledModule uncajoledModule) {
        ++this.moduleCounter;
        CajitaRewriter dcr = new CajitaRewriter(this.buildInfo, this, this.mq, false);
        CajoledModule cajoledModule = (CajoledModule)dcr.expand(uncajoledModule);
        this.moduleIndexMap.put(0, cajoledModule);
    }

    public int getModule(StringLiteral src) {
        URI inputUri;
        String loc = src.getUnquotedValue();
        if (!loc.toLowerCase().endsWith(".js")) {
            loc = loc + ".js";
        }
        try {
            inputUri = new URI(loc);
        }
        catch (URISyntaxException ex) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.INVALID_MODULE_URI, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
        ExternalReference er = new ExternalReference(inputUri, src.getFilePosition());
        CharProducer cp = this.pluginEnv.loadExternalResource(er, "text/javascript");
        if (cp == null) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.MODULE_NOT_FOUND, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
        String absoluteUri = cp.getCurrentPosition().source().getUri().toString();
        if (this.moduleNameMap.containsKey(absoluteUri)) {
            return this.moduleNameMap.get(absoluteUri);
        }
        int cur = this.moduleCounter++;
        this.moduleNameMap.put(absoluteUri, cur);
        InputSource is = new InputSource(cp.getCurrentPosition().source().getUri());
        try {
            Block intermediate;
            JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), is);
            Block input = new Parser(tq, this.mq).parse();
            tq.expectEmpty();
            if (this.isValija) {
                DefaultValijaRewriter dvr = new DefaultValijaRewriter(this.mq);
                intermediate = (Block)dvr.expand(input);
            } else {
                intermediate = input;
            }
            CajitaRewriter dcr = new CajitaRewriter(this.buildInfo, this, this.mq, false);
            UncajoledModule uncajoledModule = new UncajoledModule(intermediate);
            CajoledModule cajoledModule = (CajoledModule)dcr.expand(uncajoledModule);
            this.moduleIndexMap.put(cur, cajoledModule);
        }
        catch (ParseException e) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.PARSING_MODULE_FAILED, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
        return cur;
    }
}

