/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.xom;

import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.htmlparser.xom.Mode;
import nu.validator.htmlparser.xom.SimpleNodeFactory;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XOMTreeBuilder
extends TreeBuilder<Element> {
    private final SimpleNodeFactory nodeFactory;
    private Document document;

    protected XOMTreeBuilder(SimpleNodeFactory nodeFactory) {
        super(XmlViolationPolicy.ALLOW, true);
        this.nodeFactory = nodeFactory;
    }

    @Override
    protected void addAttributesToElement(Element element, Attributes attributes) throws SAXException {
        try {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String uri;
                String localName = attributes.getLocalName(i);
                if (element.getAttribute(localName, uri = attributes.getURI(i)) != null) continue;
                element.addAttribute(this.nodeFactory.makeAttribute(localName, uri, attributes.getValue(i), attributes.getType(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendCharacters(Element parent, char[] buf, int start, int length) throws SAXException {
        try {
            parent.appendChild((Node)this.nodeFactory.makeText(new String(buf, start, length)));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        try {
            Nodes children = oldParent.removeChildren();
            for (int i = 0; i < children.size(); ++i) {
                newParent.appendChild(children.get(i));
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendComment(Element parent, char[] buf, int start, int length) throws SAXException {
        try {
            parent.appendChild((Node)this.nodeFactory.makeComment(new String(buf, start, length)));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendCommentToDocument(char[] buf, int start, int length) throws SAXException {
        try {
            Element root = this.document.getRootElement();
            if ("http://www.xom.nu/fakeRoot".equals(root.getNamespaceURI())) {
                this.document.insertChild((Node)this.nodeFactory.makeComment(new String(buf, start, length)), this.document.indexOf((Node)root));
            } else {
                this.document.appendChild((Node)this.nodeFactory.makeComment(new String(buf, start, length)));
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected Element createElement(String name, Attributes attributes) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement(name, "http://www.w3.org/1999/xhtml");
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.addAttribute(this.nodeFactory.makeAttribute(attributes.getLocalName(i), attributes.getURI(i), attributes.getValue(i), attributes.getType(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createHtmlElementSetAsRoot(Attributes attributes) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement("html", "http://www.w3.org/1999/xhtml");
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.addAttribute(this.nodeFactory.makeAttribute(attributes.getLocalName(i), attributes.getURI(i), attributes.getValue(i), attributes.getType(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
            this.document.setRootElement(rv);
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        try {
            element.detach();
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void detachFromParentAndAppendToNewParent(Element child, Element newParent) throws SAXException {
        try {
            child.detach();
            newParent.appendChild((Node)child);
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected boolean hasChildren(Element element) throws SAXException {
        try {
            return element.getChildCount() != 0;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void insertBefore(Element child, Element sibling, Element parent) throws SAXException {
        try {
            parent.insertChild((Node)child, parent.indexOf((Node)sibling));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void insertCharactersBefore(char[] buf, int start, int length, Element sibling, Element parent) throws SAXException {
        try {
            parent.insertChild((Node)this.nodeFactory.makeText(new String(buf, start, length)), parent.indexOf((Node)sibling));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected Element parentElementFor(Element child) throws SAXException {
        try {
            ParentNode parent = child.getParent();
            if (parent != null && parent instanceof Element) {
                return (Element)parent;
            }
            return null;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element shallowClone(Element element) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement(element.getLocalName(), element.getNamespaceURI());
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                Attribute attribute = element.getAttribute(i);
                rv.addAttribute(this.nodeFactory.makeAttribute(attribute.getLocalName(), attribute.getNamespaceURI(), attribute.getValue(), attribute.getType()));
            }
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    Nodes getDocumentFragment() {
        Element rootElt = this.document.getRootElement();
        Nodes rv = rootElt.removeChildren();
        this.document = null;
        return rv;
    }

    @Override
    protected Element createElement(String name, Attributes attributes, Element form) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement(name, "http://www.w3.org/1999/xhtml", form);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.addAttribute(this.nodeFactory.makeAttribute(attributes.getLocalName(i), attributes.getURI(i), attributes.getValue(i), attributes.getType(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.document = this.nodeFactory.makeDocument();
    }

    @Override
    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        if (this.document instanceof Mode) {
            Mode modal = (Mode)this.document;
            modal.setMode(mode);
        }
    }
}

