/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.util.ArrayList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

public class PictureViewsGenerationWork
extends AbstractWork {
    protected final String repositoryName;
    protected final DocumentRef docRef;
    protected final String xpath;
    public static final String CATEGORY_PICTURE_GENERATION = "pictureViewsGeneration";

    public String getCategory() {
        return CATEGORY_PICTURE_GENERATION;
    }

    public String getTitle() {
        return "Picture views generation " + this.docRef;
    }

    public PictureViewsGenerationWork(String repositoryName, DocumentRef docRef, String xpath) {
        this.repositoryName = repositoryName;
        this.docRef = docRef;
        this.xpath = xpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() throws Exception {
        DocumentModel workingDocument = null;
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        try {
            this.initSession(this.repositoryName);
            workingDocument = this.session.getDocument(this.docRef);
            if (workingDocument != null) {
                workingDocument.detach(true);
            }
            this.commitOrRollbackTransaction();
        }
        finally {
            this.cleanUp(true, null);
        }
        if (workingDocument == null) {
            this.setStatus("Nothing to process");
            return;
        }
        this.setStatus("Generating views");
        Property fileProp = workingDocument.getProperty(this.xpath);
        ArrayList pictureTemplates = null;
        PictureResourceAdapter picture = (PictureResourceAdapter)workingDocument.getAdapter(PictureResourceAdapter.class);
        Blob blob = (Blob)fileProp.getValue();
        String filename = blob == null ? null : blob.getFilename();
        String title = workingDocument.getTitle();
        picture.fillPictureViews(blob, filename, title, pictureTemplates);
        this.startTransaction();
        this.setStatus("Saving");
        this.initSession(this.repositoryName);
        this.session.saveDocument(workingDocument);
        this.setStatus(null);
    }
}

