/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.Dom;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.templates.TemplateCompiler;
import com.google.caja.plugin.templates.TemplateSanitizer;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Pair;
import com.google.caja.util.Pipeline;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompileHtmlStage
implements Pipeline.Stage<Jobs> {
    private final CssSchema cssSchema;
    private final HtmlSchema htmlSchema;

    public CompileHtmlStage(CssSchema cssSchema, HtmlSchema htmlSchema) {
        if (null == cssSchema) {
            throw new NullPointerException();
        }
        if (null == htmlSchema) {
            throw new NullPointerException();
        }
        this.cssSchema = cssSchema;
        this.htmlSchema = htmlSchema;
    }

    @Override
    public boolean apply(Jobs jobs) {
        ArrayList<Node> ihtmlRoots = new ArrayList<Node>();
        ArrayList stylesheets = new ArrayList();
        Iterator<Job> jobIt = jobs.getJobs().iterator();
        while (jobIt.hasNext()) {
            Job job = jobIt.next();
            switch (job.getType()) {
                case HTML: {
                    ihtmlRoots.add(((Dom)job.getRoot().cast(Dom.class).node).getValue());
                    jobIt.remove();
                    break;
                }
                case CSS: {
                    stylesheets.add(job.getRoot().cast(CssTree.StyleSheet.class).node);
                    jobIt.remove();
                    break;
                }
            }
        }
        if (!ihtmlRoots.isEmpty() || !stylesheets.isEmpty()) {
            MessageQueue mq = jobs.getMessageQueue();
            TemplateSanitizer ts = new TemplateSanitizer(this.htmlSchema, mq);
            for (Node ihtmlRoot : ihtmlRoots) {
                ts.sanitize(ihtmlRoot);
            }
            TemplateCompiler tc = new TemplateCompiler(ihtmlRoots, stylesheets, this.cssSchema, this.htmlSchema, jobs.getPluginMeta(), jobs.getMessageContext(), mq);
            Pair<Node, List<Block>> htmlAndJs = tc.getSafeHtml(DomParser.makeDocument(null, null));
            jobs.getJobs().add(new Job(AncestorChain.instance(jobs.getPluginMeta().isOnlyJsEmitted() ? CompileHtmlStage.makeEmitStaticStmt((Node)htmlAndJs.a) : new Dom((Node)htmlAndJs.a))));
            for (Block bl : (List)htmlAndJs.b) {
                jobs.getJobs().add(new Job(AncestorChain.instance(bl)));
            }
        }
        return jobs.hasNoFatalErrors();
    }

    private static Statement makeEmitStaticStmt(Node node) {
        return new ExpressionStmt((Expression)QuasiBuilder.substV("IMPORTS___./*@synthetic*/htmlEmitter___./*@synthetic*/emitStatic(@html)", "html", CompileHtmlStage.renderDomAsJsStringLiteral(node)));
    }

    private static StringLiteral renderDomAsJsStringLiteral(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        Concatenator tc = new Concatenator(stringBuilder);
        Nodes.render(node, new RenderContext(tc).withEmbeddable(true));
        return StringLiteral.valueOf(Nodes.getFilePositionFor(node), stringBuilder);
    }
}

