/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssPropertyPatterns;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.plugin.CssPropertyPartType;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.PluginEnvironment;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssRewriter {
    private final PluginEnvironment env;
    private final MessageQueue mq;
    private MessageLevel invalidNodeMessageLevel = MessageLevel.ERROR;
    private static final Set<Name> LINK_PSEUDO_CLASSES = new HashSet<Name>(Arrays.asList(Name.css("link"), Name.css("visited")));
    private static final ElKey HTML_ANCHOR = ElKey.forHtmlElement("a");
    private static final Set<Name> ALLOWED_PSEUDO_CLASSES = new HashSet<Name>(Arrays.asList(Name.css("active"), Name.css("after"), Name.css("before"), Name.css("first-child"), Name.css("first-letter"), Name.css("focus"), Name.css("link"), Name.css("hover")));
    private static final Set<Name> PROPERTIES_ALLOWED_IN_LINK_CLASSES;
    private static final Pattern SAFE_SELECTOR_PART;

    public CssRewriter(PluginEnvironment env, MessageQueue mq) {
        assert (null != mq);
        assert (null != env);
        this.env = env;
        this.mq = mq;
    }

    public CssRewriter withInvalidNodeMessageLevel(MessageLevel messageLevel) {
        this.invalidNodeMessageLevel = messageLevel;
        return this;
    }

    public void rewrite(AncestorChain<? extends CssTree> t) {
        this.rewriteHistorySensitiveRulesets(t);
        this.quoteLooseWords(t);
        this.fixUnitlessLengths(t);
        this.removeUnsafeConstructs(t);
        this.removeEmptyDeclarationsAndSelectors(t);
        this.removeEmptyRuleSets(t);
        this.removeForbiddenIdents(t);
        this.removeUnsafeConstructs(t);
        this.translateUrls(t);
    }

    private void rewriteHistorySensitiveRulesets(final AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                if (!(ancestors.node instanceof CssTree.RuleSet)) {
                    return true;
                }
                Pair rewritten = CssRewriter.this.rewriteHistorySensitiveRuleset((CssTree.RuleSet)ancestors.node);
                if (rewritten != null) {
                    ((CssTree)t.node).insertBefore((ParseTreeNode)rewritten.a, (ParseTreeNode)ancestors.node);
                    ((CssTree)t.node).insertBefore((ParseTreeNode)rewritten.b, (ParseTreeNode)ancestors.node);
                    ((CssTree)t.node).removeChild((ParseTreeNode)ancestors.node);
                }
                return false;
            }
        }, t.parent);
    }

    private Pair<CssTree.RuleSet, CssTree.RuleSet> rewriteHistorySensitiveRuleset(CssTree.RuleSet ruleSet) {
        List<CssTree> linkeyChildren = Lists.newArrayList();
        List<CssTree> nonLinkeyChildren = Lists.newArrayList();
        for (CssTree cssTree : ruleSet.children()) {
            if (cssTree instanceof CssTree.Selector) {
                CssTree.Selector selector = (CssTree.Selector)cssTree;
                if (this.vetLinkToHistorySensitiveSelector(selector)) {
                    linkeyChildren.add(selector);
                    continue;
                }
                nonLinkeyChildren.add(selector);
                continue;
            }
            if (linkeyChildren.isEmpty() || nonLinkeyChildren.isEmpty()) {
                return null;
            }
            linkeyChildren.add(cssTree);
            nonLinkeyChildren.add((CssTree)cssTree.clone());
        }
        return new Pair<CssTree.RuleSet, CssTree.RuleSet>(new CssTree.RuleSet(ruleSet.getFilePosition(), linkeyChildren), new CssTree.RuleSet(ruleSet.getFilePosition(), nonLinkeyChildren));
    }

    private boolean vetLinkToHistorySensitiveSelector(CssTree.Selector selector) {
        boolean modified = false;
        for (CssTree cssTree : selector.children()) {
            if (!(cssTree instanceof CssTree.SimpleSelector)) continue;
            modified |= this.vetLinkToHistorySensitiveSimpleSelector((CssTree.SimpleSelector)cssTree);
        }
        return modified;
    }

    private boolean vetLinkToHistorySensitiveSimpleSelector(CssTree.SimpleSelector selector) {
        if (selector.children().isEmpty()) {
            return false;
        }
        if (!this.containsLinkPseudoClass(selector)) {
            return false;
        }
        CssTree firstChild = selector.children().get(0);
        if (firstChild instanceof CssTree.WildcardElement) {
            selector.replaceChild(new CssTree.IdentLiteral(firstChild.getFilePosition(), HTML_ANCHOR.toString()), firstChild);
            return true;
        }
        if (firstChild instanceof CssTree.IdentLiteral) {
            String value = ((CssTree.IdentLiteral)firstChild).getValue();
            if (!HTML_ANCHOR.equals(ElKey.forElement(Namespaces.HTML_DEFAULT, value))) {
                this.mq.addMessage((MessageTypeInt)PluginMessageType.CSS_LINK_PSEUDO_SELECTOR_NOT_ALLOWED_ON_NONANCHOR, firstChild.getFilePosition());
            }
            return false;
        }
        selector.insertBefore(new CssTree.IdentLiteral(firstChild.getFilePosition(), HTML_ANCHOR.toString()), firstChild);
        return true;
    }

    private boolean containsLinkPseudoClass(CssTree.SimpleSelector selector) {
        final boolean[] result = new boolean[1];
        selector.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> chain) {
                CssTree firstChild;
                if (chain.node instanceof CssTree.Pseudo && (firstChild = (CssTree)chain.node.children().get(0)) instanceof CssTree.IdentLiteral) {
                    CssTree.IdentLiteral ident = (CssTree.IdentLiteral)firstChild;
                    if (LINK_PSEUDO_CLASSES.contains(Name.css(ident.getValue()))) {
                        result[0] = true;
                        return false;
                    }
                }
                return true;
            }
        }, null);
        return result[0];
    }

    private void quoteLooseWords(AncestorChain<? extends CssTree> t) {
        if (t.node instanceof CssTree.Expr) {
            this.combineLooseWords((CssTree.Expr)t.cast(CssTree.Expr.class).node);
        }
        for (CssTree cssTree : ((CssTree)t.node).children()) {
            this.quoteLooseWords(AncestorChain.instance(t, cssTree));
        }
    }

    private void combineLooseWords(CssTree.Expr e) {
        int n = e.getNTerms();
        for (int i = 0; i < n; ++i) {
            int end;
            CssTree.Term t = e.getNthTerm(i);
            if (!CssRewriter.isLooseWord(t)) continue;
            Name propertyPart = t.getAttributes().get(CssValidator.CSS_PROPERTY_PART);
            StringBuilder sb = new StringBuilder();
            sb.append(t.getExprAtom().getValue());
            MutableParseTreeNode.Mutation mut = e.createMutation();
            int start = i;
            for (end = i + 1; end < n; ++end) {
                CssTree.Operation op = e.getNthOperation(end - 1);
                CssTree.Term t2 = e.getNthTerm(end);
                if (CssTree.Operator.NONE != op.getOperator() || !CssRewriter.isLooseWord(t2) || !propertyPart.equals(t2.getAttributes().get(CssValidator.CSS_PROPERTY_PART))) break;
                mut.removeChild(op);
                mut.removeChild(t2);
                sb.append(' ').append(e.getNthTerm(end).getExprAtom().getValue());
            }
            String text = sb.toString();
            FilePosition pos = FilePosition.span(t.getFilePosition(), e.getNthTerm(end - 1).getFilePosition());
            CssTree.StringLiteral quotedWords = new CssTree.StringLiteral(pos, text);
            CssTree.Term quotedTerm = new CssTree.Term(pos, null, quotedWords);
            quotedTerm.getAttributes().putAll(t.getAttributes());
            quotedTerm.getAttributes().set(CssValidator.CSS_PROPERTY_PART_TYPE, CssPropertyPartType.STRING);
            mut.replaceChild(quotedTerm, t);
            mut.execute();
            if (end - start > 1) {
                this.mq.addMessage((MessageTypeInt)PluginMessageType.QUOTED_CSS_VALUE, pos, MessagePart.Factory.valueOf(text));
            }
            n = e.getNTerms();
        }
    }

    private static boolean isLooseWord(CssTree.Term t) {
        return t.getOperator() == null && t.getExprAtom() instanceof CssTree.IdentLiteral && t.getAttributes().get(CssValidator.CSS_PROPERTY_PART_TYPE) == CssPropertyPartType.LOOSE_WORD;
    }

    private void fixUnitlessLengths(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                if (!(ancestors.node instanceof CssTree.Term)) {
                    return true;
                }
                CssTree.Term term = (CssTree.Term)ancestors.node;
                if (CssPropertyPartType.LENGTH != term.getAttributes().get(CssValidator.CSS_PROPERTY_PART_TYPE) || !(term.getExprAtom() instanceof CssTree.QuantityLiteral)) {
                    return true;
                }
                CssTree.QuantityLiteral quantity = (CssTree.QuantityLiteral)term.getExprAtom();
                String value = quantity.getValue();
                if (!CssRewriter.isZeroOrHasUnits(value)) {
                    CssTree.QuantityLiteral withUnits = new CssTree.QuantityLiteral(quantity.getFilePosition(), value + "px");
                    withUnits.getAttributes().putAll(quantity.getAttributes());
                    term.replaceChild(withUnits, quantity);
                    CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.ASSUMING_PIXELS_FOR_LENGTH, quantity.getFilePosition(), MessagePart.Factory.valueOf(value));
                }
                return false;
            }
        }, t.parent);
    }

    private static boolean isZeroOrHasUnits(String value) {
        int len = value.length();
        char ch = value.charAt(len - 1);
        if (ch == '.' || '0' <= ch && ch <= '9') {
            int i = len;
            while (--i >= 0) {
                ch = value.charAt(i);
                if ('1' > ch || ch > '9') continue;
                return false;
            }
        }
        return true;
    }

    private void removeEmptyDeclarationsAndSelectors(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.EmptyDeclaration) {
                    ParseTreeNode parent = ancestors.getParentNode();
                    if (parent instanceof MutableParseTreeNode) {
                        ((MutableParseTreeNode)parent).removeChild((ParseTreeNode)node);
                    }
                    return false;
                }
                if (node instanceof CssTree.Selector) {
                    ParseTreeNode parent;
                    CssTree.Selector sel = (CssTree.Selector)node;
                    if ((sel.children().isEmpty() || !(sel.children().get(0) instanceof CssTree.SimpleSelector)) && (parent = ancestors.getParentNode()) instanceof MutableParseTreeNode) {
                        ((MutableParseTreeNode)parent).removeChild(sel);
                    }
                    return false;
                }
                return true;
            }
        }, t.parent);
    }

    private void removeEmptyRuleSets(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                ParseTreeNode parent;
                Object node = ancestors.node;
                if (!(node instanceof CssTree.RuleSet)) {
                    return true;
                }
                CssTree.RuleSet rset = (CssTree.RuleSet)node;
                List<? extends CssTree> children = rset.children();
                if ((children.isEmpty() || children.get(children.size() - 1) instanceof CssTree.Selector || !(children.get(0) instanceof CssTree.Selector)) && (parent = ancestors.getParentNode()) instanceof MutableParseTreeNode) {
                    ((MutableParseTreeNode)parent).removeChild(rset);
                }
                return false;
            }
        }, t.parent);
    }

    private void removeForbiddenIdents(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                if (!(ac.node instanceof CssTree.SimpleSelector)) {
                    return true;
                }
                CssTree.SimpleSelector ss = (CssTree.SimpleSelector)ac.node;
                boolean ok = false;
                for (CssTree cssTree : ss.children()) {
                    String literal;
                    if (!(cssTree instanceof CssTree.ClassLiteral) && !(cssTree instanceof CssTree.IdLiteral) || !(literal = (String)cssTree.getValue()).endsWith("__")) continue;
                    CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_IDENTIFIER, cssTree.getFilePosition(), MessagePart.Factory.valueOf(literal));
                    ac.parent.node.getAttributes().set(CssValidator.INVALID, true);
                    ok = false;
                }
                return ok;
            }
        }, t.parent);
    }

    void removeUnsafeConstructs(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.SimpleSelector) {
                    for (CssTree cssTree : ((CssTree.SimpleSelector)node).children()) {
                        void var4_4;
                        Object value;
                        if (cssTree instanceof CssTree.Pseudo) {
                            CssTree cssTree2 = cssTree.children().get(0);
                        }
                        if ((value = var4_4.getValue()) == null || CssRewriter.isSafeSelectorPart(value.toString())) continue;
                        CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_IDENTIFIER, var4_4.getFilePosition(), MessagePart.Factory.valueOf(value.toString()));
                        node.getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                        return false;
                    }
                }
                return true;
            }
        }, t.parent);
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Pseudo) {
                    boolean remove = false;
                    CssTree child = ((CssTree.Pseudo)node).children().get(0);
                    if (child instanceof CssTree.IdentLiteral) {
                        Name pseudoName = Name.css(((CssTree.IdentLiteral)child).getValue());
                        if (!(ALLOWED_PSEUDO_CLASSES.contains(pseudoName) || LINK_PSEUDO_CLASSES.contains(pseudoName) && CssRewriter.this.strippedPropertiesBannedInLinkClasses(ancestors.parent.parent.cast(CssTree.Selector.class)))) {
                            CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_PSEUDO_SELECTOR, CssRewriter.this.invalidNodeMessageLevel, new MessagePart[]{node.getFilePosition(), node});
                            remove = true;
                        }
                    } else {
                        StringBuilder rendered = new StringBuilder();
                        CssPrettyPrinter tc = new CssPrettyPrinter(new Concatenator(rendered));
                        node.render(new RenderContext(tc));
                        tc.noMoreTokens();
                        CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_PSEUDO_SELECTOR, CssRewriter.this.invalidNodeMessageLevel, node.getFilePosition(), MessagePart.Factory.valueOf(rendered.toString()));
                        remove = true;
                    }
                    if (remove) {
                        CssRewriter.selectorFor(ancestors).getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                }
                return true;
            }
        }, t.parent);
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Property) {
                    if (node.getAttributes().is(CssValidator.INVALID)) {
                        CssRewriter.declarationFor(ancestors).getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                } else if (node instanceof CssTree.Attrib) {
                    if (node.getAttributes().is(CssValidator.INVALID)) {
                        CssRewriter.simpleSelectorFor(ancestors).getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                } else if (node instanceof CssTree.Term && CssPropertyPartType.URI == node.getAttributes().get(CssValidator.CSS_PROPERTY_PART_TYPE)) {
                    CssTree.Declaration decl;
                    boolean remove = false;
                    Message removeMsg = null;
                    CssTree.Term term = (CssTree.Term)node;
                    CssTree.CssLiteral content = (CssTree.CssLiteral)term.children().get(0);
                    if (content instanceof CssTree.Substitution) {
                        return true;
                    }
                    String uriStr = content.getValue();
                    try {
                        URI baseUri = content.getFilePosition().source().getUri();
                        URI uri = baseUri.resolve(new URI(uriStr));
                        ExternalReference ref = new ExternalReference(uri, content.getFilePosition());
                        if (CssRewriter.this.env.rewriteUri(ref, "image/*") == null) {
                            removeMsg = new Message((MessageTypeInt)PluginMessageType.DISALLOWED_URI, node.getFilePosition(), MessagePart.Factory.valueOf(uriStr));
                            remove = true;
                        }
                    }
                    catch (URISyntaxException ex) {
                        removeMsg = new Message((MessageTypeInt)PluginMessageType.DISALLOWED_URI, node.getFilePosition(), MessagePart.Factory.valueOf(uriStr));
                        remove = true;
                    }
                    if (remove && null != (decl = CssRewriter.declarationFor(ancestors)) && !decl.getAttributes().is(CssValidator.INVALID)) {
                        if (null != removeMsg) {
                            CssRewriter.this.mq.getMessages().add(removeMsg);
                        }
                        decl.getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                }
                return true;
            }
        }, t.parent);
        this.removeInvalidNodes(t);
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Selector && node.children().isEmpty() || node instanceof CssTree.RuleSet && (node.children().isEmpty() || node.children().get(0) instanceof CssTree.Declaration)) {
                    ((MutableParseTreeNode)ancestors.parent.node).removeChild((ParseTreeNode)node);
                    return false;
                }
                return true;
            }
        }, t.parent);
    }

    private void removeInvalidNodes(AncestorChain<? extends CssTree> t) {
        if (((CssTree)t.node).getAttributes().is(CssValidator.INVALID)) {
            ((MutableParseTreeNode)t.parent.node).removeChild((ParseTreeNode)t.node);
            return;
        }
        MutableParseTreeNode.Mutation mut = null;
        for (CssTree cssTree : ((CssTree)t.node).children()) {
            if (cssTree.getAttributes().is(CssValidator.INVALID)) {
                if (mut == null) {
                    mut = ((CssTree)t.node).createMutation();
                }
                mut.removeChild(cssTree);
                continue;
            }
            this.removeInvalidNodes(AncestorChain.instance(t, cssTree));
        }
        if (mut != null) {
            mut.execute();
        }
    }

    private void translateUrls(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Term && CssPropertyPartType.URI == CssRewriter.propertyPartType(node)) {
                    CssTree.Term term = (CssTree.Term)node;
                    CssTree.CssLiteral content = (CssTree.CssLiteral)term.children().get(0);
                    if (content instanceof CssTree.Substitution) {
                        return true;
                    }
                    String uriStr = content.getValue();
                    try {
                        URI baseUri = content.getFilePosition().source().getUri();
                        URI uri = baseUri.resolve(new URI(uriStr));
                        ExternalReference ref = new ExternalReference(uri, content.getFilePosition());
                        String rewrittenUri = CssRewriter.this.env.rewriteUri(ref, "image/*");
                        CssTree.UriLiteral replacement = new CssTree.UriLiteral(content.getFilePosition(), URI.create(rewrittenUri));
                        replacement.getAttributes().putAll(content.getAttributes());
                        term.replaceChild(replacement, content);
                    }
                    catch (URISyntaxException ex) {
                        throw new AssertionError();
                    }
                }
                return true;
            }
        }, t.parent);
    }

    private static CssTree.Declaration declarationFor(AncestorChain<?> chain) {
        AncestorChain<Object> c = chain;
        while (null != c) {
            if (c.node instanceof CssTree.Declaration) {
                return (CssTree.Declaration)c.node;
            }
            c = c.parent;
        }
        return null;
    }

    private static CssTree.SimpleSelector simpleSelectorFor(AncestorChain<?> chain) {
        AncestorChain<Object> c = chain;
        while (null != c) {
            if (c.node instanceof CssTree.SimpleSelector) {
                return (CssTree.SimpleSelector)c.node;
            }
            c = c.parent;
        }
        return null;
    }

    private static CssTree.Selector selectorFor(AncestorChain<?> chain) {
        AncestorChain<Object> c = chain;
        while (null != c) {
            if (c.node instanceof CssTree.Selector) {
                return (CssTree.Selector)c.node;
            }
            c = c.parent;
        }
        return null;
    }

    private boolean strippedPropertiesBannedInLinkClasses(AncestorChain<CssTree.Selector> sel) {
        if (!(sel.parent.node instanceof CssTree.RuleSet)) {
            return false;
        }
        Set<Name> propertyNames = PROPERTIES_ALLOWED_IN_LINK_CLASSES;
        CssTree.RuleSet rs = (CssTree.RuleSet)sel.parent.cast(CssTree.RuleSet.class).node;
        MutableParseTreeNode.Mutation mut = rs.createMutation();
        for (CssTree cssTree : rs.children()) {
            if (cssTree instanceof CssTree.Selector || cssTree instanceof CssTree.EmptyDeclaration) continue;
            CssTree.PropertyDeclaration pd = cssTree instanceof CssTree.PropertyDeclaration ? (CssTree.PropertyDeclaration)cssTree : ((CssTree.UserAgentHack)cssTree).getDeclaration();
            CssTree.Property p = pd.getProperty();
            Name propName = p.getPropertyName();
            boolean allowedInLinkClass = propertyNames.contains(propName);
            if (!allowedInLinkClass && propName.getCanonicalForm().startsWith("_")) {
                allowedInLinkClass = propertyNames.contains(Name.css(propName.getCanonicalForm().substring(1)));
            }
            if (allowedInLinkClass && !this.mightContainUrl(pd.getExpr())) continue;
            this.mq.getMessages().add(new Message((MessageTypeInt)PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, this.invalidNodeMessageLevel, p.getFilePosition(), p.getPropertyName(), ((CssTree.Selector)sel.node).getFilePosition()));
            mut.removeChild(cssTree);
        }
        mut.execute();
        return true;
    }

    private boolean mightContainUrl(CssTree.Expr expr) {
        int n = expr.getNTerms();
        for (int i = 0; i < n; ++i) {
            CssTree.CssExprAtom atom = expr.getNthTerm(i).getExprAtom();
            if (atom instanceof CssTree.IdentLiteral || atom instanceof CssTree.QuantityLiteral || atom instanceof CssTree.HashLiteral) continue;
            return true;
        }
        return false;
    }

    private static boolean isSafeSelectorPart(String s) {
        return SAFE_SELECTOR_PART.matcher(s).matches();
    }

    private static CssPropertyPartType propertyPartType(ParseTreeNode node) {
        return node.getAttributes().get(CssValidator.CSS_PROPERTY_PART_TYPE);
    }

    static {
        HashSet<Name> propNames = new HashSet<Name>(Arrays.asList(Name.css("background-color"), Name.css("color"), Name.css("cursor")));
        Set<Name> computedStyleNames = CssPropertyPatterns.HISTORY_INSENSITIVE_STYLE_WHITELIST;
        propNames.removeAll(computedStyleNames);
        PROPERTIES_ALLOWED_IN_LINK_CLASSES = Collections.unmodifiableSet(propNames);
        SAFE_SELECTOR_PART = Pattern.compile("^[#!\\.]?[a-zA-Z][_a-zA-Z0-9\\-]*$");
    }
}

