/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.plugin.ExtractedHtmlContent;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.templates.QuasiUtil;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SafeHtmlMaker {
    private static final AttribKey ID = AttribKey.forHtmlAttrib(ElKey.HTML_WILDCARD, "id");
    private final PluginMeta meta;
    private final MessageContext mc;
    private final Document doc;
    private final List<Block> js = new ArrayList<Block>();
    private final Map<Node, ParseTreeNode> scriptsPerNode;
    private final List<Node> roots;
    private final List<Statement> handlers;
    private Block currentBlock = null;
    private boolean currentBlockStyle;
    private boolean started = false;
    private boolean finished = false;
    private static final Pattern DYNID_PATTERN = Pattern.compile("id_\\d+___");

    SafeHtmlMaker(PluginMeta meta, MessageContext mc, Document doc, Map<Node, ParseTreeNode> scriptsPerNode, List<Node> roots, List<Statement> handlers) {
        this.meta = meta;
        this.mc = mc;
        this.doc = doc;
        this.scriptsPerNode = scriptsPerNode;
        this.roots = roots;
        this.handlers = handlers;
    }

    Pair<Node, List<Block>> make() {
        this.js.clear();
        this.currentBlock = null;
        for (Statement handlerDef : this.handlers) {
            this.emitStatement(handlerDef);
        }
        ArrayList<DomBone> domSkeleton = new ArrayList<DomBone>();
        ArrayList<Node> safe = new ArrayList<Node>(this.roots.size());
        for (Node root : this.roots) {
            Node one = this.makeSkeleton(root, domSkeleton);
            if (one == null) continue;
            safe.add(one);
        }
        this.fleshOutSkeleton(domSkeleton);
        Node safeHtml = this.consolidateHtml(safe);
        return Pair.pair(safeHtml, new ArrayList<Block>(this.js));
    }

    private Node makeSkeleton(Node n, List<DomBone> bones) {
        Node safe;
        if (!this.scriptsPerNode.containsKey(n)) {
            return null;
        }
        switch (n.getNodeType()) {
            case 1: {
                Element el = (Element)n;
                Block script = ExtractedHtmlContent.getExtractedScriptFor(el);
                if (script != null) {
                    bones.add(new ScriptBone(script));
                    return null;
                }
                FilePosition pos = Nodes.getFilePositionFor(el);
                safe = this.doc.createElementNS(el.getNamespaceURI(), el.getLocalName());
                Nodes.setFilePositionFor(safe, pos);
                bones.add(new NodeBone(n, safe));
                for (Node node : Nodes.childrenOf(el)) {
                    Node safeChild = this.makeSkeleton(node, bones);
                    if (safeChild == null) continue;
                    safe.appendChild(safeChild);
                }
                break;
            }
            case 3: {
                safe = this.doc.createTextNode(n.getNodeValue());
                Nodes.setFilePositionFor(safe, Nodes.getFilePositionFor(n));
                bones.add(new NodeBone(n, safe));
                break;
            }
            case 11: {
                safe = this.doc.createDocumentFragment();
                for (Node node : Nodes.childrenOf(n)) {
                    Node node2 = this.makeSkeleton(node, bones);
                    if (node2 == null) continue;
                    safe.appendChild(node2);
                }
                break;
            }
            default: {
                return null;
            }
        }
        return safe;
    }

    private void fleshOutSkeleton(List<DomBone> bones) {
        int n;
        int firstDeferredScriptIndex;
        for (firstDeferredScriptIndex = n = bones.size(); firstDeferredScriptIndex > 0 && bones.get(firstDeferredScriptIndex - 1) instanceof ScriptBone; --firstDeferredScriptIndex) {
        }
        for (int i = 0; i < n; ++i) {
            boolean splitDom;
            DomBone bone = bones.get(i);
            if (bone instanceof ScriptBone) {
                this.fleshOutScriptBlock(((ScriptBone)bone).script);
                continue;
            }
            NodeBone nb = (NodeBone)bone;
            boolean bl = splitDom = i + 1 < n && bones.get(i + 1) instanceof ScriptBone && i + 1 != firstDeferredScriptIndex;
            if (splitDom) {
                this.start();
            }
            if (nb.node instanceof Text) {
                if (splitDom) {
                    this.insertPlaceholderAfter(nb.safeNode);
                }
            } else {
                this.fleshOutElement((Element)nb.node, (Element)nb.safeNode, splitDom);
            }
            if (i + 1 != firstDeferredScriptIndex) continue;
            this.finish();
        }
        this.finish();
        this.signalLoaded();
    }

    private void start() {
        if (!this.started) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("var el___;", new Object[0]));
            this.emitStatement(SafeHtmlMaker.quasiStmt("var emitter___ = IMPORTS___.htmlEmitter___;", new Object[0]));
            this.started = true;
        }
    }

    private void finish() {
        if (this.started && !this.finished) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("el___ = emitter___./*@synthetic*/finish();", new Object[0]));
            this.finished = true;
        }
    }

    private void signalLoaded() {
        if (this.started) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/signalLoaded();", new Object[0]));
        } else if (!this.js.isEmpty()) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("IMPORTS___.htmlEmitter___./*@synthetic*/signalLoaded();", new Object[0]));
        }
    }

    private void fleshOutScriptBlock(Block script) {
        FilePosition unk = FilePosition.UNKNOWN;
        String sourcePath = this.mc.abbreviate(script.getFilePosition().source());
        this.finishBlock();
        this.emitStatement(SafeHtmlMaker.quasiStmt("try {  @scriptBody;} catch (ex___) {  ___./*@synthetic*/ getNewModuleHandler()      ./*@synthetic*/ handleUncaughtException(          ex___, onerror, @sourceFile, @line);}", "scriptBody", script, "sourceFile", StringLiteral.valueOf(unk, sourcePath), "line", StringLiteral.valueOf(unk, String.valueOf(script.getFilePosition().startLineNo()))), false);
    }

    private void insertPlaceholderAfter(Node preceder) {
        String dynId = this.meta.generateUniqueName(SafeHtmlMaker.ID.localName);
        this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/discard(    emitter___./*@synthetic*/attach(@id));", "id", StringLiteral.valueOf(FilePosition.UNKNOWN, dynId)));
        Node follower = preceder.getNextSibling();
        Node parent = preceder.getParentNode();
        if (SafeHtmlMaker.containsOnlyText(parent)) {
            assert (follower == null);
            follower = parent.getNextSibling();
            parent = parent.getParentNode();
            assert (!SafeHtmlMaker.containsOnlyText(parent));
        }
        Element placeholder = this.doc.createElementNS(Namespaces.HTML_NAMESPACE_URI, "span");
        placeholder.setAttributeNS(Namespaces.HTML_NAMESPACE_URI, SafeHtmlMaker.ID.localName, dynId);
        parent.insertBefore(placeholder, follower);
    }

    private static boolean containsOnlyText(Node n) {
        if (!(n instanceof Element)) {
            return false;
        }
        Element el = (Element)n;
        ElKey schemaKey = ElKey.forElement(el);
        if (schemaKey.isHtml()) {
            HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(schemaKey.localName);
            return mode != HtmlTextEscapingMode.PCDATA;
        }
        return false;
    }

    private void fleshOutElement(Element el, Element safe, boolean splitDom) {
        FilePosition pos = Nodes.getFilePositionFor(el);
        String dynId = null;
        if (splitDom) {
            dynId = this.makeDynamicId(null, pos);
            this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/attach(@id);", "id", StringLiteral.valueOf(FilePosition.UNKNOWN, dynId)));
        }
        Nodes.setFilePositionFor(safe, pos);
        ElKey elKey = ElKey.forElement(el);
        Attr id = null;
        for (Attr attr : Nodes.attributesOf(el)) {
            if (!this.scriptsPerNode.containsKey(attr)) continue;
            AttribKey attrKey = AttribKey.forAttribute(elKey, attr);
            Expression dynamicValue = (Expression)this.scriptsPerNode.get(attr);
            if (SafeHtmlMaker.ID.ns.uri != attrKey.ns.uri || !SafeHtmlMaker.ID.localName.equals(attrKey.localName)) {
                if (dynamicValue == null || dynamicValue instanceof StringLiteral) {
                    this.emitStaticAttr(attr, (StringLiteral)dynamicValue, safe);
                    continue;
                }
                dynId = this.makeDynamicId(dynId, pos);
                this.emitDynamicAttr(attr, dynamicValue);
                continue;
            }
            assert (id == null);
            id = attr;
        }
        if (id != null) {
            Expression dynamicValue = (Expression)this.scriptsPerNode.get(id);
            if (dynId == null && (dynamicValue == null || dynamicValue instanceof StringLiteral)) {
                this.emitStaticAttr(id, (StringLiteral)dynamicValue, safe);
            } else {
                dynId = this.makeDynamicId(dynId, pos);
                this.emitDynamicAttr(id, dynamicValue);
            }
        }
        if (dynId != null) {
            assert (!safe.hasAttributeNS(SafeHtmlMaker.ID.ns.uri, SafeHtmlMaker.ID.localName));
            safe.setAttributeNS(SafeHtmlMaker.ID.ns.uri, SafeHtmlMaker.ID.localName, dynId);
            if (id == null) {
                this.emitStatement(SafeHtmlMaker.quasiStmt("el___./*@synthetic*/removeAttribute('id');", new Object[0]));
            }
        }
    }

    private void emitStaticAttr(Attr a, StringLiteral dynamicValue, Element safe) {
        Attr safeAttr = this.doc.createAttributeNS(a.getNamespaceURI(), a.getLocalName());
        safeAttr.setValue(dynamicValue == null ? a.getValue() : dynamicValue.getUnquotedValue());
        Nodes.setFilePositionFor(safeAttr, Nodes.getFilePositionFor(a));
        Nodes.setFilePositionForValue(safeAttr, Nodes.getFilePositionForValue(a));
        safe.setAttributeNodeNS(safeAttr);
    }

    private void emitDynamicAttr(Attr a, Expression dynamicValue) {
        FilePosition pos = Nodes.getFilePositionFor(a);
        String name = a.getName();
        if (dynamicValue instanceof FunctionConstructor) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("el___.@name = @eventAdapter;", "name", new Reference(SyntheticNodes.s(new Identifier(pos, name))), "eventAdapter", dynamicValue));
        } else {
            this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/setAttr(el___, @name, @value);", "name", StringLiteral.valueOf(pos, name), "value", dynamicValue));
        }
    }

    private String makeDynamicId(String dynId, FilePosition pos) {
        this.start();
        if (dynId == null) {
            dynId = this.meta.generateUniqueName(SafeHtmlMaker.ID.localName);
            this.emitStatement(SafeHtmlMaker.quasiStmt("el___ = emitter___./*@synthetic*/byId(@id);", "id", StringLiteral.valueOf(pos, dynId)));
        }
        assert (SafeHtmlMaker.isDynamicId(dynId));
        return dynId;
    }

    private static boolean isDynamicId(String id) {
        return DYNID_PATTERN.matcher(id).matches();
    }

    private static Statement quasiStmt(String quasi, Object ... args) {
        return QuasiUtil.quasiStmt(quasi, args);
    }

    private void emitStatement(Statement s) {
        this.emitStatement(s, true);
    }

    private void emitStatement(Statement s, boolean translated) {
        if (translated != this.currentBlockStyle) {
            this.currentBlock = null;
        }
        if (this.currentBlock == null) {
            Block block = new Block();
            this.js.add(block);
            if (translated) {
                this.currentBlock = new Block();
                TranslatedCode code = new TranslatedCode(this.currentBlock);
                block.appendChild(code);
            } else {
                this.currentBlock = block;
            }
            this.currentBlockStyle = translated;
        }
        this.currentBlock.appendChild(s);
    }

    private Node consolidateHtml(List<Node> nodes) {
        DocumentFragment f;
        if (nodes.isEmpty()) {
            return this.doc.createDocumentFragment();
        }
        Node first = nodes.get(0);
        List<Node> rest = nodes.subList(1, nodes.size());
        if (rest.isEmpty()) {
            return first;
        }
        FilePosition pos = Nodes.getFilePositionFor(first);
        if (first instanceof DocumentFragment) {
            f = (DocumentFragment)first;
        } else {
            f = this.doc.createDocumentFragment();
            f.appendChild(first);
        }
        for (Node one : rest) {
            pos = FilePosition.span(pos, Nodes.getFilePositionFor(one));
            if (one instanceof DocumentFragment) {
                Node c = one.getFirstChild();
                while (c != null) {
                    Node next = c.getNextSibling();
                    f.appendChild(c);
                    c = next;
                }
                continue;
            }
            f.appendChild(one);
        }
        Nodes.setFilePositionFor(f, pos);
        return f;
    }

    private void finishBlock() {
        this.currentBlock = null;
    }

    private static class ScriptBone
    extends DomBone {
        final Block script;

        ScriptBone(Block script) {
            this.script = script;
        }

        public String toString() {
            return "(" + this.getClass().getSimpleName() + ")";
        }
    }

    private static class NodeBone
    extends DomBone {
        final Node node;
        final Node safeNode;

        NodeBone(Node node, Node safeNode) {
            this.node = node;
            this.safeNode = safeNode;
        }

        public String toString() {
            return "(" + this.getClass().getSimpleName() + " " + this.safeNode.getNodeName() + ")";
        }
    }

    private static class DomBone {
        private DomBone() {
        }
    }
}

