/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.AttributesImpl;
import com.google.caja.parser.html.Html5ElementStack;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CajaTreeBuilder
extends TreeBuilder<Node> {
    private static final boolean DEBUG = false;
    private Token<HtmlTokenType> startTok;
    private Token<HtmlTokenType> endTok;
    private Element rootElement;
    private FilePosition fragmentBounds;
    private final Set<Node> unpoppedElements = new HashSet<Node>();
    private final Document doc;
    private final boolean needsDebugData;
    private final MessageQueue mq;

    CajaTreeBuilder(Document doc, boolean needsDebugData, MessageQueue mq) {
        super(XmlViolationPolicy.ALLOW, false);
        this.doc = doc;
        this.needsDebugData = needsDebugData;
        this.mq = mq;
        this.setIgnoringComments(false);
        this.setScriptingEnabled(true);
    }

    Element getRootElement() {
        return this.rootElement;
    }

    FilePosition getFragmentBounds() {
        return this.fragmentBounds;
    }

    FilePosition getErrorLocation() {
        return this.startTok.pos != this.endTok.pos ? FilePosition.span(this.startTok.pos, this.endTok.pos) : this.startTok.pos;
    }

    void setTokenContext(Token<HtmlTokenType> start, Token<HtmlTokenType> end) {
        this.startTok = start;
        this.endTok = end;
        if (this.fragmentBounds == null) {
            this.fragmentBounds = start.pos;
        }
    }

    void finish(FilePosition pos) {
        Token<HtmlTokenType> eofToken = Token.instance("", HtmlTokenType.IGNORABLE, pos);
        this.setTokenContext(eofToken, eofToken);
        this.fragmentBounds = FilePosition.span(this.fragmentBounds, pos);
        try {
            this.eof();
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void appendCommentToDocument(char[] buf, int start, int length) {
        this.appendComment(this.doc.getDocumentElement(), buf, start, length);
    }

    protected void appendComment(Node el, char[] buf, int start, int length) {
        Comment comment = this.doc.createComment(new String(buf, start, length));
        el.appendChild(comment);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(comment, this.startTok.pos);
        }
    }

    protected void appendCharacters(Node n, char[] buf, int start, int length) {
        this.insertCharactersBefore(buf, start, length, null, n);
    }

    protected void insertCharactersBefore(char[] buf, int start, int length, Node sibling, Node parent) {
        String plainText;
        Node priorSibling = sibling != null ? sibling.getPreviousSibling() : parent.getLastChild();
        FilePosition pos = null;
        String htmlText = null;
        String tokText = CajaTreeBuilder.bufferMatches(buf, start, length, this.startTok.text) ? this.startTok.text : String.valueOf(buf, start, length);
        if (this.startTok.type == HtmlTokenType.TEXT) {
            pos = this.startTok.pos;
            htmlText = tokText;
            plainText = Nodes.decode(htmlText);
        } else if (this.startTok.type == HtmlTokenType.UNESCAPED || this.startTok.type == HtmlTokenType.CDATA) {
            pos = this.startTok.pos;
            plainText = htmlText = tokText;
        } else {
            pos = this.endTok.pos;
            plainText = tokText;
            if (this.needsDebugData) {
                htmlText = Nodes.encode(plainText);
            }
        }
        if (priorSibling != null && priorSibling.getNodeType() == 3) {
            Text prevText = (Text)priorSibling;
            String prevTextContent = prevText.getTextContent();
            StringBuilder sb = new StringBuilder(prevTextContent.length() + length);
            sb.append(prevTextContent).append(buf, start, length);
            Text combined = this.doc.createTextNode(sb.toString());
            if (this.needsDebugData) {
                Nodes.setFilePositionFor(combined, FilePosition.span(Nodes.getFilePositionFor(priorSibling), pos));
                Nodes.setRawText(combined, Nodes.getRawText(prevText) + htmlText);
            }
            parent.replaceChild(combined, priorSibling);
            return;
        }
        Text text = this.doc.createTextNode(plainText);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(text, pos);
            Nodes.setRawText(text, htmlText);
        }
        parent.insertBefore(text, sibling);
    }

    protected void addAttributesToElement(Node node, Attributes attributes) {
        Element el = (Element)node;
        for (Attr a : this.getAttributes(attributes)) {
            String name = a.getName();
            if (!el.hasAttributeNS(a.getNamespaceURI(), a.getLocalName())) {
                el.setAttributeNodeNS(a);
                continue;
            }
            this.mq.addMessage((MessageTypeInt)MessageType.DUPLICATE_ATTRIBUTE, Nodes.getFilePositionFor(a), MessagePart.Factory.valueOf(name), Nodes.getFilePositionFor(el.getAttributeNodeNS(a.getNamespaceURI(), a.getLocalName())));
        }
    }

    protected void insertBefore(Node child, Node sibling, Node parent) {
        parent.insertBefore(child, sibling);
    }

    protected Node parentElementFor(Node child) {
        return child.getParentNode();
    }

    protected void appendChildrenToNewParent(Node oldParent, Node newParent) {
        Node child;
        while ((child = oldParent.getFirstChild()) != null) {
            newParent.appendChild(child);
        }
    }

    protected void detachFromParentAndAppendToNewParent(Node child, Node newParent) {
        newParent.appendChild(child);
    }

    protected Node shallowClone(Node node) {
        Node clone = node.cloneNode(false);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(clone, Nodes.getFilePositionFor(node));
        }
        switch (node.getNodeType()) {
            case 2: {
                if (!this.needsDebugData) break;
                Nodes.setFilePositionForValue((Attr)clone, Nodes.getFilePositionForValue((Attr)node));
                break;
            }
            case 1: {
                Element el = (Element)node;
                Element cloneEl = (Element)clone;
                NamedNodeMap attrs = el.getAttributes();
                int n = attrs.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr a = (Attr)attrs.item(i);
                    Attr cloneA = cloneEl.getAttributeNodeNS(a.getNamespaceURI(), a.getLocalName());
                    if (!this.needsDebugData) continue;
                    Nodes.setFilePositionFor(cloneA, Nodes.getFilePositionFor(a));
                    Nodes.setFilePositionForValue(cloneA, Nodes.getFilePositionForValue(a));
                }
                break;
            }
            case 3: 
            case 4: {
                if (!this.needsDebugData) break;
                Text t = (Text)node;
                Nodes.setRawText(t, Nodes.getRawText(t));
            }
        }
        return clone;
    }

    protected boolean hasChildren(Node node) {
        return node.getFirstChild() != null;
    }

    protected void detachFromParent(Node node) {
        node.getParentNode().removeChild(node);
    }

    protected Element createHtmlElementSetAsRoot(Attributes attributes) {
        Element documentElement;
        this.rootElement = documentElement = this.createElement("html", attributes);
        return documentElement;
    }

    protected Element createElement(String name, Attributes attributes) {
        Element el = (name = name.intern()).indexOf(58) < 0 ? this.doc.createElementNS(Namespaces.HTML_NAMESPACE_URI, name) : this.doc.createElement(name);
        this.addAttributesToElement(el, attributes);
        if (this.needsDebugData) {
            FilePosition pos = this.startTok == null ? null : (this.startTok.type == HtmlTokenType.TAGBEGIN && CajaTreeBuilder.tagMatchesElementName(CajaTreeBuilder.tagName(this.startTok.text), name) ? FilePosition.span(this.startTok.pos, this.endTok.pos) : FilePosition.startOf(this.startTok.pos));
            Nodes.setFilePositionFor(el, pos);
        }
        return el;
    }

    protected void elementPopped(String name, Node node) {
        this.unpoppedElements.remove(node);
        if (this.needsDebugData) {
            name = Html5ElementStack.canonicalElementName(name);
            FilePosition endPos = this.startTok.type == HtmlTokenType.TAGBEGIN && (CajaTreeBuilder.isEndTag(this.startTok.text) || "select".equals(name)) && CajaTreeBuilder.tagCloses(CajaTreeBuilder.tagName(this.startTok.text), name) ? this.endTok.pos : FilePosition.startOf(this.startTok.pos);
            FilePosition startPos = Nodes.getFilePositionFor(node);
            if (startPos == null) {
                Node first = node.getFirstChild();
                FilePosition filePosition = startPos = first == null ? endPos : Nodes.getFilePositionFor(first);
            }
            if (endPos.endCharInFile() >= startPos.endCharInFile()) {
                Nodes.setFilePositionFor(node, FilePosition.span(startPos, endPos));
            }
        }
    }

    protected void bodyClosed(Node body) {
        this.elementPopped("body", body);
    }

    protected void htmlClosed(Node html) {
        this.elementPopped("html", html);
    }

    protected void elementPushed(String name, Node node) {
        this.unpoppedElements.add(node);
    }

    void closeUnclosedNodes() {
        if (this.needsDebugData) {
            for (Node node : this.unpoppedElements) {
                Nodes.setFilePositionFor(node, FilePosition.span(Nodes.getFilePositionFor(node), this.endTok.pos));
            }
        }
        this.unpoppedElements.clear();
    }

    private static boolean bufferMatches(char[] buf, int start, int len, String s) {
        if (len != s.length()) {
            return false;
        }
        int i = len;
        while (--i >= 0) {
            if (s.charAt(i) == buf[start + i]) continue;
            return false;
        }
        return true;
    }

    private List<Attr> getAttributes(Attributes attributes) {
        if (attributes instanceof AttributesImpl) {
            return ((AttributesImpl)attributes).getAttributes();
        }
        int n = attributes.getLength();
        if (n == 0) {
            return Collections.emptyList();
        }
        Attr[] newAttribs = new Attr[n];
        FilePosition pos = FilePosition.startOf(this.startTok.pos);
        for (int i = 0; i < n; ++i) {
            Attr a = this.doc.createAttributeNS(attributes.getURI(i), attributes.getLocalName(i));
            a.setNodeValue(attributes.getValue(i));
            if (this.needsDebugData) {
                Nodes.setFilePositionFor(a, pos);
                Nodes.setFilePositionForValue(a, pos);
            }
            newAttribs[i] = a;
        }
        return Arrays.asList(newAttribs);
    }

    static boolean isEndTag(String tokenText) {
        return tokenText.length() >= 2 && tokenText.charAt(1) == '/';
    }

    static String tagName(String tokenText) {
        String name = tokenText.substring(CajaTreeBuilder.isEndTag(tokenText) ? 2 : 1);
        return Html5ElementStack.canonicalElementName(name);
    }

    static boolean tagMatchesElementName(String tagName, String elementName) {
        return tagName.equals(elementName) || tagName.equals("image") && elementName.equals("img");
    }

    static boolean tagCloses(String tagName, String elementName) {
        return CajaTreeBuilder.tagMatchesElementName(tagName, elementName) || CajaTreeBuilder.isHeading(tagName) && CajaTreeBuilder.isHeading(elementName);
    }

    static boolean isHeading(String tagName) {
        if (tagName.length() != 2 || 'h' != tagName.charAt(0)) {
            return false;
        }
        char ch1 = tagName.charAt(1);
        return ch1 >= '1' && ch1 <= '6';
    }
}

