/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryService;
import org.nuxeo.ecm.platform.annotations.service.PermissionManager;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class DefaultNuxeoPermissionManager
implements PermissionManager {
    private static final Log log = LogFactory.getLog(DefaultNuxeoPermissionManager.class);
    private AnnotationsRepositoryService service;
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();

    public DefaultNuxeoPermissionManager() {
        try {
            this.service = (AnnotationsRepositoryService)Framework.getService(AnnotationsRepositoryService.class);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public boolean check(NuxeoPrincipal user, String permission, URI uri) throws AnnotationException {
        boolean bl;
        block5: {
            DocumentView view = this.translator.getDocumentViewFromUri(uri);
            CoreSession session = null;
            try {
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                session = mgr.getDefaultRepository().open();
                DocumentModel model = session.getDocument(view.getDocumentLocation().getDocRef());
                bl = this.service.check(user, permission, model);
                if (session == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw new AnnotationException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        CoreInstance.getInstance().close(session);
                    }
                    throw throwable;
                }
            }
            CoreInstance.getInstance().close(session);
        }
        return bl;
    }
}

