/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.plugin.stages.DebuggingSymbols;
import com.google.caja.reporting.MessageQueue;
import java.util.Map;

final class CajaRuntimeDebuggingRewriter
extends Rewriter {
    private final DebuggingSymbols symbols;

    CajaRuntimeDebuggingRewriter(DebuggingSymbols symbols, MessageQueue mq) {
        super(mq, false, false);
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="callPub", synopsis="adds debug info to ___.callPub calls", reason="", matches="___.callPub(@obj, @name, @args)", substitutes="___.callPub(@obj, @name, @args, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="deletePub", synopsis="adds debug info to ___.deletePub calls", reason="", matches="___.deletePub(@obj, @name)", substitutes="___.deletePub(@obj, @name, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="readPub", synopsis="adds debug info to ___.readPub calls", reason="", matches="___.readPub(@obj, @name)", substitutes="___.readPub(@obj, @name, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="inPub", synopsis="adds debug info to ___.inPub calls", reason="", matches="___.inPub(@obj, @name)", substitutes="___.inPub(@obj, @name, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="setPub", synopsis="adds debug info to ___.setPub calls", reason="", matches="___.setPub(@obj, @name, @val)", substitutes="___.setPub(@obj, @name, @val, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="asFunc", synopsis="Turns .CALL___ calls into ___.asFunc calls with debugging info", reason="", matches="@fun.CALL___", substitutes="___.asFunc(@fun, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="frozenFuncAnon", synopsis="adds debug info to ___.markFuncFreeze calls", reason="", matches="___.markFuncFreeze(@fun)", substitutes="___.markFuncFreeze(@fun, undefined, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="frozenFuncNamed", synopsis="adds debug info to ___.markFuncFreeze calls", reason="", matches="___.markFuncFreeze(@fun, @name)", substitutes="___.markFuncFreeze(@fun, @name, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="construct", synopsis="adds debug info to ___.construct calls", reason="", matches="___.construct(@fun, @args)", substitutes="___.construct(@fun, @args, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new Rule(){

            @RuleDescription(name="simplifyCall", synopsis="remove fasttrack so it can't dereference null", reason="fasttrack useless in debug mode but it can still causeerrors outside our stack", matches="@obj.@x_canCall___ ? (@obj.@x(@actuals*)) : @operation", substitutes="@operation")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return this.transform(n, s);
            }
        });
        this.addRule(new Rule(){

            @RuleDescription(name="simplifyRead", synopsis="remove fasttrack so it can't dereference null", reason="fasttrack useless in debug mode but it can still causeerrors outside our stack", matches="@obj.@key_canRead___ ? (@obj.@key) : @operation", substitutes="@operation")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return this.transform(n, s);
            }
        });
        this.addRule(new Rule(){

            @RuleDescription(name="simplifySet", synopsis="remove fasttrack so it can't dereference null", reason="fasttrack useless in debug mode but it can still causeerrors outside our stack", matches="@obj.@key_canSet___ === @obj ? (@obj.@key = @y) : @operation", substitutes="@operation")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return this.transform(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="inOperator", synopsis="Add null check to rhs of 'in' operator", reason="to identify the source of null pointer exceptions", matches="(@key in @posNode)", substitutes="(@key in ___.requireObject(@posNode, @debug))")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new AddPositionParamRule(){

            @RuleDescription(name="userException", synopsis="Add null check to rhs of 'in' operator", reason="identify the location where user errors are thrown", matches="throw @ex", substitutes="throw ___.userException(@ex, @debug)")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return super.fire(n, s);
            }
        });
        this.addRule(new Rule(){

            @RuleDescription(name="fallback", synopsis="handles cases not recognized by ", reason="because not everything is a runtime check")
            public ParseTreeNode fire(ParseTreeNode n, Scope s) {
                return this.expandAll(n, s);
            }
        });
        this.symbols = symbols;
    }

    private FilePosition spanningPos(ParseTreeNode node) {
        FilePosition pos = node.getFilePosition();
        if (!node.getAttributes().is(SyntheticNodes.SYNTHETIC) && !InputSource.UNKNOWN.equals(pos.source())) {
            return pos;
        }
        FilePosition start = null;
        FilePosition end = null;
        for (ParseTreeNode parseTreeNode : node.children()) {
            FilePosition childPos = this.spanningPos(parseTreeNode);
            if (childPos == null) continue;
            if (start == null) {
                start = end = childPos;
                continue;
            }
            if (!start.source().equals(childPos.source())) continue;
            if (childPos.startCharInFile() < start.startCharInFile()) {
                start = childPos;
            }
            if (childPos.endCharInFile() <= end.endCharInFile()) continue;
            end = childPos;
        }
        if (start != null) {
            return FilePosition.span(start, end);
        }
        return null;
    }

    abstract class AddPositionParamRule
    extends Rule {
        AddPositionParamRule() {
        }

        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                FilePosition pos;
                Map<String, ParseTreeNode> newBindings = AddPositionParamRule.makeBindings();
                for (Map.Entry<String, ParseTreeNode> entry : bindings.entrySet()) {
                    newBindings.put(entry.getKey(), CajaRuntimeDebuggingRewriter.this.expand(entry.getValue(), scope));
                }
                ParseTreeNode posNode = bindings.get("posNode");
                if (posNode == null) {
                    posNode = node;
                }
                if ((pos = CajaRuntimeDebuggingRewriter.this.spanningPos(posNode)) == null) {
                    pos = FilePosition.UNKNOWN;
                }
                int index = CajaRuntimeDebuggingRewriter.this.symbols.indexForPosition(pos);
                newBindings.put("debug", new IntegerLiteral(FilePosition.UNKNOWN, index));
                return QuasiBuilder.subst(this.getRuleDescription().substitutes(), newBindings);
            }
            return NONE;
        }
    }
}

