/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.digestlinker.linker;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.digestlinker.linker.TempBlob;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class JSONDigestBlobDecoder
implements JSONBlobDecoder {
    private static final Logger log = LogManager.getLogger(JSONDigestBlobDecoder.class);
    String DEFAULT_PROVIDER = "default";
    String FORCE_VALIDATION = "force";
    private static ThreadLocal<String> currentDigest = new ThreadLocal();
    BlobManager manager = (BlobManager)Framework.getService(BlobManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        if (!jsonObject.has("digest")) {
            return null;
        }
        BlobInfo blobInfo = this.getBlobInfo(jsonObject);
        currentDigest.set(blobInfo.digest);
        try {
            BlobProvider blobProvider;
            String providerId = this.prop(jsonObject, "providerId", null);
            boolean validate = this.FORCE_VALIDATION.equals(this.prop(jsonObject, "validate", null)) || this.FORCE_VALIDATION.equals(this.prop(jsonObject, "validation", null)) || "true".equals(this.prop(jsonObject, "validate", null)) || "true".equals(this.prop(jsonObject, "validation", null));
            BlobProvider blobProvider2 = blobProvider = providerId != null ? this.manager.getBlobProvider(providerId) : this.getDefaultProvider();
            if (blobProvider == null) {
                log.warn("No blobProvider. Can not find blob");
                Blob blob = null;
                return blob;
            }
            log.debug("blobProvider[{}]", (Object)blobProvider.getClass().getName());
            if (!JSONDigestBlobDecoder.isAdmin() && !blobProvider.hasCreateFromKeyPermission()) {
                throw new NuxeoException("User [" + JSONDigestBlobDecoder.whoami() + "] has no permissions to call this operation", 401);
            }
            try {
                Blob blob;
                if (blobInfo.length != null && blobInfo.length < 0L) {
                    blobInfo.length = null;
                }
                if ((blob = blobProvider.readBlob(blobInfo)) == null) {
                    throw new NuxeoException("Can not find blob with digest[" + blobInfo.digest + "]");
                }
                if (validate) {
                    this.validateByStream(blobInfo, blobProvider);
                    if (blob.getLength() == -1L) {
                        blob = blobProvider.readBlob(blobInfo);
                    }
                } else if (blobInfo.length == null) {
                    if (blob.getLength() == -1L) {
                        log.debug("Binary manager did not return length for blob [{}]", (Object)blob.getDigest());
                        this.validateByStream(blobInfo, blobProvider);
                        blob = blobProvider.readBlob(blobInfo);
                    } else {
                        blobInfo.length = blob.getLength();
                        blob = blobProvider.readBlob(blobInfo);
                        log.debug("set length[{}] for blob with digest[{}]", (Object)blobInfo.length, (Object)blobInfo.digest);
                    }
                }
                log.debug("Blob linked with digest[{}], length[{}], mime[{}]", (Object)blobInfo.digest, (Object)blobInfo.length, (Object)blobInfo.mimeType);
                Blob blob2 = blob;
                return blob2;
            }
            catch (IOException e) {
                log.warn(String.format("IO exception retrieving blob by key [%s]", blobInfo.key), (Throwable)e);
                if (validate) {
                    throw new NuxeoException("Blob with digest [" + blobInfo.key + "] is not found by blob provider [" + providerId + "]");
                }
                log.warn("Can not determine size of blob {}. It probably does not exist", (Object)blobInfo.key);
                Blob blob = null;
                currentDigest.remove();
                return blob;
            }
        }
        finally {
            currentDigest.remove();
        }
    }

    protected void validateByStream(BlobInfo blobInfo, BlobProvider blobProvider) throws IOException {
        try (InputStream binary = blobProvider.getStream((ManagedBlob)new TempBlob(blobInfo.key));){
            if (binary == null) {
                log.error("blob with digest[{}] not found", (Object)blobInfo.digest);
                throw new IOException(String.format("No binary found for hash [%s]", blobInfo.key));
            }
            if (blobInfo.length == null) {
                blobInfo.length = binary.available();
                if (blobInfo.length < 0L) {
                    throw new IOException(String.format("Binary with digest[%s] has invalid length [%s]", blobInfo.key, blobInfo.length));
                }
                log.debug("set length[{}] for blob with digest[{}]", (Object)blobInfo.length, (Object)blobInfo.digest);
            }
        }
    }

    protected BlobInfo getBlobInfo(ObjectNode jsonObject) {
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.digest = blobInfo.key = this.prop(jsonObject, "digest", null);
        blobInfo.length = this.propInt(jsonObject, "length");
        blobInfo.filename = this.prop(jsonObject, "filename", null);
        if (blobInfo.filename == null) {
            blobInfo.filename = this.prop(jsonObject, "name", null);
        }
        blobInfo.mimeType = this.prop(jsonObject, "mime-type", null);
        blobInfo.encoding = this.prop(jsonObject, "encoding", null);
        return blobInfo;
    }

    String prop(ObjectNode jsonObject, String key, String def) {
        return jsonObject.has(key) ? jsonObject.get(key).textValue() : def;
    }

    Long propInt(ObjectNode jsonObject, String key) {
        return jsonObject.has(key) ? Long.valueOf(jsonObject.get(key).longValue()) : null;
    }

    BlobProvider getDefaultProvider() {
        BlobProvider provider = this.manager.getBlobProvider(this.DEFAULT_PROVIDER);
        if (provider != null) {
            return provider;
        }
        Map providers = this.manager.getBlobProviders();
        if (!providers.isEmpty()) {
            return (BlobProvider)providers.values().iterator().next();
        }
        return null;
    }

    private static String whoami() {
        NuxeoPrincipal principal = NuxeoPrincipal.getCurrent();
        if (null == principal) {
            log.debug("No principal found");
            return null;
        }
        return principal.getName();
    }

    private static boolean isAdmin() {
        NuxeoPrincipal principal = NuxeoPrincipal.getCurrent();
        if (null == principal) {
            log.debug("No principal found");
            return false;
        }
        String name = principal.getName();
        Boolean isAdmin = principal.isAdministrator();
        log.debug("Found principal  [{}], admin={}", (Object)name, (Object)isAdmin);
        return isAdmin;
    }

    public static String currentDigest() {
        return currentDigest.get();
    }
}

