/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.digestlinker.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.blob.azure.AzureBinaryManager;

public class DevModeAzureBinaryManager
extends AzureBinaryManager {
    private static final Logger log = LogManager.getLogger(DevModeAzureBinaryManager.class);
    public static final String DEV_CONN_PROPERTY = "dev.connection.string";

    public void setupCloudClient() throws IOException {
        String connURL = (String)this.properties.get(DEV_CONN_PROPERTY);
        if (connURL == null) {
            connURL = "UseDevelopmentStorage=true";
        }
        try {
            log.debug("Azure URL [{}]", (Object)connURL);
            this.storageAccount = CloudStorageAccount.parse((String)connURL);
            this.blobClient = this.storageAccount.createCloudBlobClient();
            String containerName = this.getProperty("container");
            log.debug("Azure Container [{}]", (Object)containerName);
            this.container = this.blobClient.getContainerReference(containerName);
            this.container.createIfNotExists();
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            throw new IOException("Unable to initialize Azure binary manager", e);
        }
        this.prefix = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.properties.get("prefix")), (CharSequence)"");
        String delimiter = this.blobClient.getDirectoryDelimiter();
        if (StringUtils.isNotBlank((CharSequence)this.prefix) && !this.prefix.endsWith(delimiter)) {
            this.prefix = this.prefix + delimiter;
        }
        if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
            this.prefix = this.prefix + this.namespace;
            if (!this.prefix.endsWith(delimiter)) {
                this.prefix = this.prefix + delimiter;
            }
        }
    }
}

