/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.Vector;

public class Word
extends ParsedTextImpl {
    Word(String text, float ascent, float descent, Vector startPoint, Vector endPoint, float spaceWidth) {
        super(text, startPoint, endPoint, ascent, descent, spaceWidth);
    }

    @Override
    public void accumulate(TextAssembler p, String contextName) {
        p.process(this, contextName);
    }

    @Override
    public void assemble(TextAssembler p) {
        p.renderText(this);
    }

    private static String formatPercent(float f) {
        return String.format("%.2f%%", Float.valueOf(f));
    }

    private String wordMarkup(String text, PdfReader reader, int page, TextAssembler assembler) {
        Rectangle mediaBox = reader.getBoxSize(page, "media");
        Rectangle clipBox = reader.getBoxSize(page, "clip");
        mediaBox.normalize();
        if (clipBox != null) {
            clipBox.normalize();
        } else {
            Rectangle cropBox = reader.getBoxSize(page, "trim");
            if (cropBox != null) {
                cropBox.normalize();
                clipBox = cropBox;
            } else {
                clipBox = mediaBox;
            }
        }
        float xOffset = clipBox.getLeft() - mediaBox.getLeft();
        float yOffset = clipBox.getTop() - mediaBox.getTop();
        Vector startPoint = this.getStartPoint();
        Vector endPoint = this.getEndPoint();
        float pageWidth = clipBox.getWidth();
        float pageHeight = clipBox.getHeight();
        float leftPercent = (float)((double)((startPoint.get(0) - xOffset) / pageWidth) * 100.0);
        float bottom = endPoint.get(1) + yOffset - this.getDescent();
        float bottomPercent = bottom / pageHeight * 100.0f;
        StringBuilder result = new StringBuilder();
        float width = this.getWidth();
        float widthPercent = width / pageWidth * 100.0f;
        float height = this.getAscent();
        float heightPercent = height / pageHeight * 100.0f;
        String myId = assembler.getWordId();
        result.append("<span class=\"t-word\" style=\"bottom: ").append(Word.formatPercent(bottomPercent)).append("; left: ").append(Word.formatPercent(leftPercent)).append("; width: ").append(Word.formatPercent(widthPercent)).append("; height: ").append(Word.formatPercent(heightPercent)).append(";\"").append(" id=\"").append(myId).append("\">").append(Word.escapeHTML(text)).append(" ");
        result.append("</span> ");
        return result.toString();
    }

    private static String escapeHTML(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @Override
    public FinalText getFinalText(PdfReader reader, int page, TextAssembler assembler) {
        return new FinalText(this.wordMarkup(this.getText().trim(), reader, page, assembler));
    }

    public String toString() {
        return "[Word: [" + this.getText() + "] " + this.getStartPoint() + ", " + this.getEndPoint() + "] lead" + this.getAscent() + "]";
    }
}

