/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.editor;

import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.ui.web.component.editor.UIHtmlEditor;
import org.nuxeo.ecm.platform.ui.web.htmleditor.api.HtmlEditorPluginService;
import org.nuxeo.runtime.api.Framework;

public class HtmlEditorRenderer
extends HtmlBasicInputRenderer {
    private static Map<String, String> pluginsOptions;
    private static Map<String, String> toolbarPluginsOptions;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        HashMap<String, String> options;
        HtmlEditorPluginService pluginService;
        if (!component.isRendered()) {
            return;
        }
        UIHtmlEditor editorComp = (UIHtmlEditor)component;
        ResponseWriter writer = context.getResponseWriter();
        Locale locale = context.getViewRoot().getLocale();
        if (pluginsOptions == null) {
            pluginService = (HtmlEditorPluginService)Framework.getService(HtmlEditorPluginService.class);
            options = new HashMap<String, String>();
            options.put("plugins", pluginService.getFormattedPluginsNames());
            pluginsOptions = options;
        }
        if (toolbarPluginsOptions == null) {
            pluginService = (HtmlEditorPluginService)Framework.getService(HtmlEditorPluginService.class);
            options = new HashMap();
            options.put("toolbar", pluginService.getFormattedToolbarsButtonsNames());
            toolbarPluginsOptions = options;
        }
        String clientId = editorComp.getClientId(context);
        boolean disableHtmlInit = Boolean.TRUE.equals(editorComp.getDisableHtmlInit());
        writer.startElement("textarea", (UIComponent)editorComp);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String editorSelector = editorComp.getEditorSelector();
        if (Boolean.TRUE.equals(editorComp.getDisableHtmlInit())) {
            writer.writeAttribute("class", (Object)(editorSelector + ",disableMCEInit"), null);
        } else {
            writer.writeAttribute("class", (Object)editorSelector, null);
        }
        writer.writeAttribute("rows", (Object)editorComp.getRows(), null);
        writer.writeAttribute("cols", (Object)editorComp.getCols(), null);
        Object currentValue = HtmlEditorRenderer.getCurrentValue((UIInput)editorComp);
        if (currentValue != null) {
            writer.writeText(currentValue, null);
        } else {
            writer.writeText((Object)"", null);
        }
        writer.endElement("textarea");
        if (!disableHtmlInit) {
            writer.startElement("script", (UIComponent)editorComp);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            String compConfiguration = editorComp.getConfiguration();
            if (StringUtils.isBlank((CharSequence)compConfiguration)) {
                compConfiguration = "{}";
            }
            String scriptContent = "initTinyMCE(" + editorComp.getWidth() + ", " + editorComp.getHeight() + ", '" + clientId + "', '" + pluginsOptions.get("plugins") + "', '" + locale.getLanguage() + "', '" + toolbarPluginsOptions.get("toolbar") + "', '" + compConfiguration + "');";
            writer.writeText((Object)scriptContent, null);
            String ajaxScriptContent = "jsf.ajax.addOnEvent(function(data) {if (data.status === 'success') {removeTinyMCE('" + clientId + "');" + "addTinyMCE('" + clientId + "');" + "}});";
            writer.writeText((Object)ajaxScriptContent, null);
            String scriptContent2 = "jQuery(document.getElementById('" + clientId + "')).closest('form').bind('ajaxsubmit', function() { var editor = tinyMCE.editors['" + clientId + "']; if (editor != undefined) {editor.save()};});";
            writer.writeText((Object)scriptContent2, null);
            writer.endElement("script");
        }
        writer.flush();
    }

    protected static Object getCurrentValue(UIInput comp) {
        Object submitted = comp.getSubmittedValue();
        if (submitted != null) {
            return submitted;
        }
        return comp.getValue();
    }

    protected static String generateOptions(Map<String, String> options) {
        ArrayList<String> strOptions = new ArrayList<String>();
        for (Map.Entry<String, String> option : options.entrySet()) {
            strOptions.add(option.getKey() + ": \"" + option.getValue() + "\"");
        }
        StringBuilder res = new StringBuilder();
        res.append('{');
        res.append(StringUtils.join((Object[])strOptions.toArray(), (String)", "));
        res.append('}');
        return res.toString();
    }
}

