/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.validator;

import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.text.SeamTextLexer;
import org.jboss.seam.text.SeamTextParser;

public class FormattedTextValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NUMBER_OF_CONTEXT_CHARS_AFTER = 10;
    private static final int NUMBER_OF_CONTEXT_CHARS_BEFORE = 10;
    private static final String END_OF_TEXT = "END OF TEXT";
    String firstError;
    String firstErrorDetail;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        block6: {
            this.firstError = null;
            this.firstErrorDetail = null;
            if (value == null) {
                return;
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Value is not a string: " + value);
            }
            String text = (String)value;
            SeamTextParser parser = this.getSeamTextParser(text);
            try {
                parser.startRule();
            }
            catch (TokenStreamException tse) {
                throw new RuntimeException(tse);
            }
            catch (RecognitionException re) {
                if (this.firstError != null) break block6;
                this.firstError = this.getParserErrorMessage(text, re);
                this.firstErrorDetail = re.getMessage().replace("\uffff", END_OF_TEXT);
            }
        }
        if (this.firstError != null) {
            throw new ValidatorException(new FacesMessage(this.firstError, this.firstErrorDetail));
        }
    }

    public SeamTextParser getSeamTextParser(String text) {
        StringReader r = new StringReader(text);
        SeamTextLexer lexer = new SeamTextLexer((Reader)r);
        return new SeamTextParser((TokenStream)lexer);
    }

    public String getParserErrorMessage(String originalText, RecognitionException re) {
        String parserErrorMsg = NoViableAltException.class.isAssignableFrom(((Object)((Object)re)).getClass()) ? this.getNoViableAltErrorMessage(re.getMessage(), FormattedTextValidator.getErrorLocation(originalText, re, this.getNumberOfCharsBeforeErrorLocation(), this.getNumberOfCharsAfterErrorLocation())) : (MismatchedTokenException.class.isAssignableFrom(((Object)((Object)re)).getClass()) ? this.getMismatchedTokenErrorMessage(re.getMessage(), FormattedTextValidator.getErrorLocation(originalText, re, this.getNumberOfCharsBeforeErrorLocation(), this.getNumberOfCharsAfterErrorLocation())) : (SemanticException.class.isAssignableFrom(((Object)((Object)re)).getClass()) ? this.getSemanticErrorMessage(re.getMessage()) : re.getMessage()));
        return parserErrorMsg;
    }

    public int getNumberOfCharsBeforeErrorLocation() {
        return 10;
    }

    public int getNumberOfCharsAfterErrorLocation() {
        return 10;
    }

    public String getNoViableAltErrorMessage(String originalMessage, String location) {
        return location != null ? "Text parsing error at '..." + location.trim() + "...'" : "Text parsing error, " + originalMessage.replace("\uffff", END_OF_TEXT);
    }

    public String getMismatchedTokenErrorMessage(String originalMessage, String location) {
        return location != null ? "Text parsing error at '..." + location.trim() + "...'" : "Text parsing error, " + originalMessage.replace("\uffff", END_OF_TEXT);
    }

    public String getSemanticErrorMessage(String originalMessage) {
        return "Text parsing error, " + originalMessage.replace("\uffff", END_OF_TEXT);
    }

    public static String getErrorLocation(String originalText, RecognitionException re, int charsBefore, int charsAfter) {
        int beginIndex = Math.max(re.getColumn() - 1 - charsBefore, 0);
        int endIndex = Math.min(re.getColumn() + charsAfter, originalText.length());
        String location = null;
        if (beginIndex > 0 && beginIndex < endIndex && endIndex > 0 && endIndex < originalText.length()) {
            location = originalText.substring(beginIndex, endIndex);
        }
        if (location == null) {
            return location;
        }
        return location.replace("\n", " ").replace("\r", " ").replace("#{", "# {");
    }

    public static String getErrorMessage(String originalText, RecognitionException re) {
        return re.getMessage().replace("\uffff", END_OF_TEXT) + " at '" + FormattedTextValidator.getErrorLocation(originalText, re, 10, 10) + "'";
    }
}

