/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeActions;
import org.nuxeo.ecm.webapp.tree.TreeInvalidatorBean;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.CollapsibleSubTableToggleEvent;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="treeActions")
@Install(precedence=10)
public class TreeActionsBean
implements TreeActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TreeActionsBean.class);
    public static final String NODE_SELECTED_MARKER = TreeActionsBean.class.getName() + "_NODE_SELECTED_MARKER";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected Map<String, List<DocumentTreeNode>> trees = new HashMap<String, List<DocumentTreeNode>>();
    protected String currentDocumentPath;
    @In(create=true, required=false)
    protected Boolean isUserWorkspace;
    @In(create=true, required=false)
    protected String currentPersonalWorkspacePath;
    protected String userWorkspacePath;
    protected String firstAccessibleParentPath;
    protected boolean showingGlobalRoot;
    @In(create=true)
    protected TreeInvalidatorBean treeInvalidator;

    @Override
    public List<DocumentTreeNode> getTreeRoots() {
        return this.getTreeRoots(false);
    }

    public List<DocumentTreeNode> getTreeRoots(String treeName) {
        return this.getTreeRoots(false, treeName);
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot, String treeName) {
        return this.getTreeRoots(showRoot, this.navigationContext.getCurrentDocument(), treeName);
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot) {
        return this.getTreeRoots(showRoot, this.navigationContext.getCurrentDocument(), "navigation");
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot, DocumentModel currentDocument) {
        return this.getTreeRoots(showRoot, currentDocument, "navigation");
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot, DocumentModel currentDocument, String treeName) {
        List<DocumentTreeNode> currentTree;
        if (this.treeInvalidator.needsInvalidation()) {
            this.reset();
            this.treeInvalidator.invalidationDone();
        }
        if (Boolean.TRUE.equals(this.isUserWorkspace)) {
            this.userWorkspacePath = this.getUserWorkspacePath();
        }
        if ((currentTree = this.trees.get(treeName)) == null) {
            DocumentTreeNode treeRoot;
            currentTree = new ArrayList<DocumentTreeNode>();
            DocumentModel globalRoot = null;
            DocumentModel firstAccessibleParent = null;
            if (currentDocument != null) {
                if (Boolean.TRUE.equals(this.isUserWorkspace)) {
                    firstAccessibleParent = this.documentManager.getDocument((DocumentRef)new PathRef(this.userWorkspacePath));
                } else {
                    List parents = this.documentManager.getParentDocuments(currentDocument.getRef());
                    if (!parents.isEmpty()) {
                        firstAccessibleParent = (DocumentModel)parents.get(0);
                    } else if (!"Root".equals(currentDocument.getType()) && currentDocument.isFolder()) {
                        firstAccessibleParent = currentDocument;
                    } else if (showRoot) {
                        firstAccessibleParent = currentDocument;
                    }
                }
                if (showRoot && (firstAccessibleParent == null || !"/".equals(firstAccessibleParent.getPathAsString())) && this.documentManager.exists((DocumentRef)new PathRef("/"))) {
                    globalRoot = this.documentManager.getRootDocument();
                }
            }
            boolean bl = this.showingGlobalRoot = globalRoot != null;
            if (this.showingGlobalRoot) {
                treeRoot = this.newDocumentTreeNode(globalRoot, treeName);
                currentTree.add(treeRoot);
                log.debug((Object)"Tree initialized with additional global root");
            }
            String string = this.firstAccessibleParentPath = firstAccessibleParent == null ? null : firstAccessibleParent.getPathAsString();
            if (firstAccessibleParent != null) {
                treeRoot = this.newDocumentTreeNode(firstAccessibleParent, treeName);
                currentTree.add(treeRoot);
                log.debug((Object)("Tree initialized with document: " + firstAccessibleParent.getId()));
            } else {
                log.debug((Object)"Could not initialize the navigation tree: no parent found for current document");
            }
            this.trees.put(treeName, currentTree);
        }
        return this.trees.get(treeName);
    }

    protected DocumentTreeNode newDocumentTreeNode(DocumentModel doc, String treeName) {
        TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
        Filter filter = treeManager.getFilter(treeName);
        Filter leafFilter = treeManager.getLeafFilter(treeName);
        Sorter sorter = treeManager.getSorter(treeName);
        String pageProvider = treeManager.getPageProviderName(treeName);
        return new DocumentTreeNodeImpl(doc, filter, leafFilter, sorter, pageProvider);
    }

    @Deprecated
    public void changeExpandListener(CollapsibleSubTableToggleEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(NODE_SELECTED_MARKER, Boolean.TRUE);
    }

    @Override
    public String getCurrentDocumentPath() {
        DocumentModel currentDoc;
        if (this.currentDocumentPath == null && (currentDoc = this.navigationContext.getCurrentDocument()) != null) {
            this.currentDocumentPath = currentDoc.getPathAsString();
        }
        return this.currentDocumentPath;
    }

    protected String getUserWorkspacePath() {
        String currentDocumentPath = this.getCurrentDocumentPath();
        if (StringUtils.isBlank((CharSequence)this.currentPersonalWorkspacePath)) {
            this.reset();
            return currentDocumentPath;
        }
        if (this.userWorkspacePath == null || !this.userWorkspacePath.contains(this.currentPersonalWorkspacePath)) {
            this.reset();
            return this.documentManager.exists((DocumentRef)new PathRef(this.currentPersonalWorkspacePath)) ? this.currentPersonalWorkspacePath : this.findFarthestContainerPath(currentDocumentPath);
        }
        return this.userWorkspacePath;
    }

    protected String findFarthestContainerPath(String documentPath) {
        String result;
        Path containerPath = new Path(documentPath);
        do {
            result = containerPath.toString();
        } while (!(containerPath = containerPath.removeLastSegments(1)).isRoot() && this.documentManager.exists((DocumentRef)new PathRef(containerPath.toString())));
        return result;
    }

    @Override
    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetCurrentDocumentData() {
        this.currentDocumentPath = null;
        if (this.checkIfTreeInvalidationNeeded()) {
            this.trees.clear();
            return;
        }
        for (List<DocumentTreeNode> tree : this.trees.values()) {
            if (tree == null || !tree.isEmpty()) continue;
            Object var2_2 = null;
        }
    }

    protected boolean checkIfTreeInvalidationNeeded() {
        DocumentModel currentDocument = (DocumentModel)Component.getInstance((String)"currentDocument");
        if (currentDocument != null && this.showingGlobalRoot) {
            return true;
        }
        return currentDocument != null && this.firstAccessibleParentPath != null && currentDocument.getPathAsString() != null && (!currentDocument.getPathAsString().contains(this.firstAccessibleParentPath) || this.userWorkspacePath != null && currentDocument.getPathAsString().contains(this.userWorkspacePath) && !this.firstAccessibleParentPath.contains(this.userWorkspacePath));
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentChanged", "documentSecurityChanged", "documentChildrenChanged"}, create=false)
    @BypassInterceptors
    public void reset() {
        this.trees.clear();
        this.resetCurrentDocumentData();
    }

    @Observer(value={"personnalWorkspace"}, create=true)
    public void switchToUserWorkspace() {
        this.userWorkspacePath = this.getCurrentDocumentPath();
        this.reset();
    }

    @Observer(value={"goHome"}, create=false)
    @BypassInterceptors
    public void switchToDocumentBase() {
    }

    public String forceTreeRefresh() throws IOException {
        this.resetCurrentDocumentData();
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setContentType("application/xml; charset=UTF-8");
        response.getWriter().write("<response>OK</response>");
        context.responseComplete();
        return null;
    }

    @Override
    public void toggleListener() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(NODE_SELECTED_MARKER, Boolean.TRUE);
    }

    @Override
    public boolean isNodeExpandEvent() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            return Boolean.TRUE.equals(externalContext.getRequestMap().get(NODE_SELECTED_MARKER));
        }
        return false;
    }
}

