/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkedit;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.bulkedit.BulkEditHelper;
import org.nuxeo.ecm.webapp.bulkedit.BulkEditService;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="bulkEditActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class BulkEditActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SELECTION_EDITED = "selectionEdited";
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient TypeManager typeManager;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected DocumentModel fictiveDocumentModel;

    public List<String> getCommonsLayouts() {
        if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return Collections.emptyList();
        }
        List<DocumentModel> selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return BulkEditHelper.getCommonLayouts(this.typeManager, selectedDocuments);
    }

    protected List<String> getCommonSchemas() {
        if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return Collections.emptyList();
        }
        List<DocumentModel> selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return BulkEditHelper.getCommonSchemas(selectedDocuments);
    }

    public DocumentModel getBulkEditDocumentModel() {
        if (this.fictiveDocumentModel == null) {
            this.fictiveDocumentModel = new SimpleDocumentModel();
        }
        return this.fictiveDocumentModel;
    }

    public String bulkEditSelection() {
        if (this.fictiveDocumentModel != null) {
            List<DocumentModel> selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            ((BulkEditService)Framework.getService(BulkEditService.class)).updateDocuments(this.documentManager, this.fictiveDocumentModel, selectedDocuments);
            for (DocumentModel doc : selectedDocuments) {
                Events.instance().raiseEvent("documentChanged", new Object[]{doc});
            }
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("label.bulk.edit.documents.updated"), new Object[]{selectedDocuments.size()});
            Events.instance().raiseEvent(SELECTION_EDITED, new Object[]{selectedDocuments, this.fictiveDocumentModel});
            this.fictiveDocumentModel = null;
        }
        return null;
    }

    public boolean getCanEdit() {
        if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return false;
        }
        List<DocumentModel> docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        for (DocumentModel doc : docs) {
            if (this.documentManager.hasPermission(doc.getRef(), "Write")) continue;
            return false;
        }
        return true;
    }

    @Observer(value={"CURRENT_SELECTIONUpdated"})
    public void cancel() {
        this.fictiveDocumentModel = null;
    }
}

