/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.ui.web.binding.BlockingVariableMapper;

public class SubWidgetTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(SubWidgetTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute recomputeIds;

    public SubWidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.recomputeIds = this.getAttribute("recomputeIds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        Widget widget = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
        String widgetVariableName = RenderVariables.widgetVariables.widget.name();
        TagAttribute widgetAttribute = helper.createAttribute(widgetVariableName, "#{" + widgetVariableName + "}");
        if (widgetAttribute != null) {
            widget = (Widget)widgetAttribute.getObject(ctx, Widget.class);
        }
        if (widget == null) {
            log.error((Object)("Could not resolve widget " + widgetAttribute));
            return;
        }
        Widget[] subWidgets = widget.getSubWidgets();
        if (subWidgets == null || subWidgets.length == 0) {
            return;
        }
        boolean recomputeIdsBool = false;
        if (this.recomputeIds != null) {
            recomputeIdsBool = this.recomputeIds.getBoolean(ctx);
        }
        if (FaceletHandlerHelper.isAliasOptimEnabled()) {
            VariableMapper orig = ctx.getVariableMapper();
            try {
                this.applyOptimized(ctx, parent, orig, subWidgets, helper, recomputeIdsBool);
            }
            finally {
                ctx.setVariableMapper(orig);
            }
        } else {
            this.applyCompat(ctx, parent, subWidgets, helper, recomputeIdsBool);
        }
    }

    protected void applyOptimized(FaceletContext ctx, UIComponent parent, VariableMapper orig, Widget[] subWidgets, FaceletHandlerHelper helper, boolean recomputeIdsBool) throws IOException, FacesException, ELException {
        int subWidgetCounter = 0;
        for (Widget subWidget : subWidgets) {
            BlockingVariableMapper vm = new BlockingVariableMapper(orig);
            ctx.setVariableMapper((VariableMapper)vm);
            if (subWidget != null && (subWidget.getId() == null || recomputeIdsBool)) {
                WidgetTagHandler.generateWidgetId(ctx, helper, subWidget, false);
            }
            WidgetTagHandler.exposeWidgetVariables(ctx, vm, subWidget, subWidgetCounter, true);
            this.nextHandler.apply(ctx, parent);
            ++subWidgetCounter;
        }
    }

    protected void applyCompat(FaceletContext ctx, UIComponent parent, Widget[] subWidgets, FaceletHandlerHelper helper, boolean recomputeIdsBool) throws IOException, FacesException, ELException {
        int subWidgetCounter = 0;
        for (Widget subWidget : subWidgets) {
            if (subWidget != null && (subWidget.getId() == null || recomputeIdsBool)) {
                WidgetTagHandler.generateWidgetId(ctx, helper, subWidget, false);
            }
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression subWidgetVe = eFactory.createValueExpression((Object)subWidget, Widget.class);
            Integer level = null;
            String tagConfigId = null;
            if (subWidget != null) {
                level = subWidget.getLevel();
                tagConfigId = subWidget.getTagConfigId();
            }
            variables.put(RenderVariables.widgetVariables.widget.name(), subWidgetVe);
            ValueExpression subWidgetIndexVe = eFactory.createValueExpression((Object)subWidgetCounter, Integer.class);
            variables.put(RenderVariables.widgetVariables.widgetIndex.name(), subWidgetIndexVe);
            variables.put(RenderVariables.widgetVariables.widgetIndex.name() + "_" + level, subWidgetIndexVe);
            if (subWidget != null) {
                for (Map.Entry ctrl : subWidget.getControls().entrySet()) {
                    String key = (String)ctrl.getKey();
                    String name = RenderVariables.widgetVariables.widgetControl.name() + "_" + key;
                    Serializable value = (Serializable)ctrl.getValue();
                    variables.put(name, eFactory.createValueExpression((Object)value, Object.class));
                }
            }
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.widget.name());
            blockedPatterns.add(RenderVariables.widgetVariables.widgetIndex.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetControl.name() + "_*");
            FaceletHandler handlerWithVars = helper.getAliasFaceletHandler(tagConfigId, variables, blockedPatterns, this.nextHandler);
            handlerWithVars.apply(ctx, parent);
            ++subWidgetCounter;
        }
    }
}

