/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;

public class DirectorySelectItemComparator
implements Comparator<DirectorySelectItem>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] ordering;
    private Boolean caseSensitive;
    private Collator collator;
    private Locale locale;

    public DirectorySelectItemComparator(String ordering, Boolean caseSensitive, Locale locale) {
        this.ordering = StringUtils.split((String)ordering, (String)",");
        this.caseSensitive = caseSensitive;
        if (locale == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.locale = context.getViewRoot().getLocale();
        } else {
            this.locale = locale;
        }
        this.collator = Collator.getInstance(this.locale);
        if (Boolean.TRUE.equals(this.caseSensitive)) {
            this.collator.setStrength(2);
        } else {
            this.collator.setStrength(1);
        }
    }

    public DirectorySelectItemComparator(String ordering, Boolean caseSentitive) {
        this(ordering, caseSentitive, null);
    }

    public DirectorySelectItemComparator(String ordering) {
        this(ordering, Boolean.FALSE);
    }

    protected int compareField(String field, DirectorySelectItem item1, DirectorySelectItem item2) {
        if ("label".equals(field)) {
            String label1 = item1.getLabel();
            String label2 = item2.getLabel();
            return this.collator.compare(label1, label2);
        }
        if ("id".equals(field)) {
            String value1 = String.valueOf(item1.getValue());
            String value2 = String.valueOf(item2.getValue());
            return this.collator.compare(value1, value2);
        }
        if ("ordering".equals(field)) {
            long orderItem1 = item1.getOrdering();
            long orderItem2 = item2.getOrdering();
            return Long.valueOf(orderItem1).compareTo(orderItem2);
        }
        throw new RuntimeException("Invalid sort criteria " + field);
    }

    @Override
    public int compare(DirectorySelectItem item1, DirectorySelectItem item2) {
        for (String field : this.ordering) {
            int compare = this.compareField(field, item1, item2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

